/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gnutella.net;

import xnap.plugin.gnutella.Plugin;
import xnap.net.*;
import xnap.util.*;

import java.util.*;

public class SearchResult extends AbstractSearchResult
{

    //--- Data field(s) ---
    
    private Servent servent;
    private int index;
    private int port;
    private GUID guid;

    //--- Constructor(s) ---

    public SearchResult(long size, String filename, String address, int port,
			int i, Servent s, GUID guid) 
    {
	super(size, -1, -1, -1, new User(address), filename, "",
	      Plugin.getInstance());
	servent = s;
	index = i;
	this.port = port;
	this.guid = guid;
    }

    
    //--- Method(s) ---

    public String getShortFilename() {
        return filename;
    }

    public Servent getServent()
    {
	return servent;
    }

    public int getPort()
    {
	return port;
    }

    public int getIndex()
    {
	return index;
    }

    public GUID getServentID()
    {
	return guid;
    }

    public String getIP()
    {
	return user.getName();
    }

    
    public IDownload getDownload()
    {
	return new Download(this);
    }

    public IBrowse getBrowse()
    {
	return null;
    }

}

