/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gnutella.net;

import xnap.util.*;
import xnap.net.*;

import java.util.*;

public class Search extends AbstractSearch 
{

    //--- Data Field(s) ---
    
    private RoutingTable routingTable = RoutingTable.getInstance();
    private Object lock = new Object();
    private QueryMessage qmsg;
    
    //--- Constructor(s) ---

    public Search(SearchFilter filter, int priority, int maxResults) 
    {
	super(filter, priority,  maxResults);
	qmsg = new QueryMessage((short) 0, filter.getSearchText(), false);
    }

    //--- Method(s) ---


    public void connect()
    {
	Debug.log("gntella search: started");
	routingTable.startSearch(qmsg, this);
    }
    
    public void close()
    {
	Debug.log("gnutella search: aborted");
	routingTable.stopSearch(qmsg);
	finished = true;
    }
}

