/*
 * 04/12/2001
 *
 * ReadLineReader.java
 * Copyright (C) 2001 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.gnutella.net;

import xnap.util.*;

import java.io.InputStream;
import java.io.IOException;
import java.io.EOFException;

/**
 *
 * @version 0.1 04/12/2001
 * @author Frederik Zimmer
 */

public class ReadLineReader 
{
    //--- Constant(s) ---

    //--- Data field(s) ---

    private InputStream in;

    //--- Constructor(s) ---
    
    public ReadLineReader(InputStream in) 
    {
	this.in = in;
    }
    
    public String readLine()
    {
	StringBuffer sb = new StringBuffer();
	int data;
	boolean cr = false;
	boolean lf = false;
	
	try {
	    while ((data = in.read()) != -1) {
		if (data == 10) {
		    if (cr || lf) {
			if (sb.length() == 0) {
			    return null;
			}
			else {
			    return sb.toString();
			}
		    }
		    lf = true;
		}
		else if (data == 13) {
		    cr = true;
		}
		else {
		    lf = false;
		    cr = false;
		    sb.append((char) data);	
		}
	    }
	}
	catch (IOException e) {
	    Debug.log("ReadLineReader:" + e.getMessage());
	}
	 return null;
    }
}


