/*
 * 03/30/2001
 *
 * QueryMessage.java
 * Copyright (C) 2001 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.gnutella.net;

import xnap.plugin.gnutella.util.*;
import xnap.plugin.gnutella.io.*;

import java.io.IOException;
import java.io.EOFException;
import java.util.ArrayList;





//  import ziga.Hash;
//  import ziga.SHA1;
//  import ziga.io.*;
//  import ziga.util.Base32;
//  import ziga.util.Base32FormatException;

/**
 *
 * @version 0.1 11/03/2001
 * @author Frederik Zimmer
 */

public class QueryMessage extends Message 
{
    public static final int INCLUDE_NO_URN = 0;
    public static final int INCLUDE_ANY_URN = 1;
    public static final int INCLUDE_SHA1_URN = 2;
    public static final int INCLUDE_BITPRINT_URN = 3;
    private static final int PAYLOAD_LENGTH = 257;
    private static final int FS = 28;
    
    protected short minSpeed;
    protected String searchString;
    protected String extraData;
    protected int includeURN;
    //  protected Hash[] hash;
    
    public QueryMessage(short minSpeed, String searchString, 
			boolean includeURN) 
	throws IllegalArgumentException 
    {
	super(DescriptorHeader.QUERY, 
	      3 + searchString.length() + (includeURN ? 5 : 0));
	if (header.payloadLength > PAYLOAD_LENGTH) {
	    throw new IllegalArgumentException();
	}
	this.minSpeed = minSpeed;
	this.searchString = searchString;
	if (includeURN) {
	    extraData = "urn:";
	}
    }
    
    public QueryMessage(short minSpeed, String urn) 
	throws IllegalArgumentException 
    {
	super(DescriptorHeader.QUERY, 4 + urn.length());
	if (header.payloadLength > PAYLOAD_LENGTH) {
	    throw new IllegalArgumentException();
	}
	this.minSpeed = minSpeed;
	this.searchString = "";
	extraData = urn;
    }
    
    public QueryMessage(DescriptorHeader header, DataInputStream in) 
	throws IOException, InvalidMessageException 
    {
	super(header);
	if (header.payloadLength > PAYLOAD_LENGTH) {
	    throw new InvalidMessageException("Payload-length too high");
	}
	includeURN = INCLUDE_NO_URN;
	read(in);
    }
    
    public void write(DataOutputStream out) 
	throws IOException 
    {
	super.write(out);
	out.writeShort(minSpeed);
	out.write(searchString.getBytes());
	out.write(0);
	if (extraData != null) {
	    out.write(extraData.getBytes());
	    out.write(0);
	}
    }
    
    public void read(DataInputStream in) 
	throws IOException 
    {
	int dataLength = header.payloadLength - 2;
	
	if (dataLength < 1) {
	    throw new EOFException();
	}
		
	byte[] data = new byte[dataLength];
		
	minSpeed = in.readShort();
		
	in.readFully(data);
		
	int i;
	for (i = 0; i < dataLength && data[i] != 0; i++) {
	}
		
	if (i == dataLength) {
	    header.payloadLength++;
	}
	
	searchString = new String(data, 0, i);

	int extraDataLength = dataLength - ++i;
		
	if (extraDataLength > 0) {
	    if (data[data.length-1] == 0) {
		extraDataLength--;
		if (extraDataLength == 0) {
		    header.payloadLength--;
		}
	    }
	    else {
		header.payloadLength++;
	    }
	}
		
	if (extraDataLength > 0) {
	    ArrayList hashes = new ArrayList();
	    extraData = new String(data, i, extraDataLength);
	    for (int j = i, start = i; j < dataLength; j++) {
		if (data[j] == FS || data[j] == 0 || j+1 == dataLength) {
		    int length = j-start;
		    if (length >= 4 && data[start] == 'u' && data[start+1] == 'r' &&
			data[start+2] == 'n' && data[start+3] == ':') {
			start += 4;
			if (length == 4) {
			    includeURN = INCLUDE_ANY_URN;
			}
			else if ((length == 9 || length == 41) && data[start] == 's' && data[start+1] == 'h' && data[start+2] == 'a' &&
				 data[start+3] == '1' && data[start+4] == ':') {
			    includeURN = INCLUDE_SHA1_URN;
			    if (length == 41) {
				start += 5;
				try {
				    byte[] bytes = Base32.decode(new String(data, start, 32));
				    //  hashes.add(new SHA1(bytes));
				} catch(Base32FormatException e) {}
			    }
			}
			else if ((length == 13 || length == 85) && data[start] == 'b' && data[start+1] == 'i' && data[start+2] == 't' &&
				 data[start+3] == 'p' && data[start+4] == 'r' && data[start+5] == 'i' &&
				 data[start+6] == 'n' && data[start+7] == 't' && data[start+8] == ':') {
			    includeURN = INCLUDE_BITPRINT_URN;
			    if (length == 85) {
				start += 9;
				try {
				    byte[] bytes = Base32.decode(new String(data, start, 32));
				    //  hashes.add(new SHA1(bytes));
				} catch(Base32FormatException e) {}
			    }
			}
		    }
		    start = j+1;
		}
	    }

	    //  if (hashes.size() > 0) {
//  		//  hash = new Hash[hashes.size()];
//  //  		hash = (Hash[]) hashes.toArray(hash);
//  	    }
	}
    }
	
    public String getSearchString() {
	return searchString;
    }
	
    public int getIncludeURN() {
	return includeURN;
    }
	
    //  public Hash[] getHash() {
//  	return hash;
//      }
		
}
