/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.util;

import xnap.util.*;

public class GiftPreferences extends PluginPreferencesSupport {

    //--- Constant(s) ---

    //--- Data field(s) ---

    private static GiftPreferences singleton = null;

    //--- Constructor(s) ---

    private GiftPreferences()
    {
	super("plugin.gift");

	setDefault("daemon", "");
	setDefault("host", "127.0.0.1");
	setDefault("port", 1213 + "");
    }

    //--- Method(s) ---

    public static synchronized GiftPreferences getInstance() {
	if (singleton == null) {
	    singleton = new GiftPreferences();
	}

	return singleton;
    }

    public void destroy() {
	singleton = null;
    }

    public String getGiftDaemon() {
        return get("daemon");
    }

    public void setGiftDaemon(String newValue) {
	set("daemon", newValue);
    }    

    public String getGiftHost() {
	return get("host");
    }

    public void setGiftHost(String newValue) {
	set("host", newValue);
    }    

    public int getGiftPort() {
        return getInt("port");
    }

    public void setGiftPort(int newValue) {
	set("port", newValue);
    }

}
