/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.net.event;

/**
 * StatsEvent  Wrapps giFT-protocol statistics
 *
 * @author <a href="mailto:tvanlessen@taval.de">Tammo van Lessen</a>
 * @version CVS $Id: StatsEvent.java,v 1.1 2003/01/15 16:17:54 squig Exp $
 */
public class StatsEvent extends Event {
    //~ Instance fields --------------------------------------------------------

    private String protocol;
    private float size;
    private long files;
    private long users;

    //~ Constructors -----------------------------------------------------------

    /**
     * Constructor for StatsEvent.
     *
     * @param protocol
     */
    public StatsEvent(String protocol) {
        super();
        this.protocol = protocol;
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * Sets the files.
     *
     * @param files The files to set
     */
    public void setFiles(long files) {
        this.files = files;
    }

    /**
     * Returns the files.
     *
     * @return long
     */
    public long getFiles() {
        return files;
    }

    /**
     * Returns the protocol.
     *
     * @return String
     */
    public String getProtocol() {
        return protocol;
    }

    /**
     * Sets the size.
     *
     * @param size The size to set
     */
    public void setSize(float size) {
        this.size = size;
    }

    /**
     * Returns the size.
     *
     * @return long
     */
    public float getSize() {
        return size;
    }

    /**
     * Sets the users.
     *
     * @param users The users to set
     */
    public void setUsers(long users) {
        this.users = users;
    }

    /**
     * Returns the users.
     *
     * @return long
     */
    public long getUsers() {
        return users;
    }
}
