/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.net.event;

import java.util.Enumeration;
import java.util.Hashtable;


/**
 * ShareItemEvent
 *
 * @author <a href="mailto:tvanlessen@taval.de">Tammo van Lessen</a>
 * @version CVS $Id: ShareItemEvent.java,v 1.1 2003/01/15 16:17:54 squig Exp $
 */
public class ShareItemEvent extends Event {
    //~ Instance fields --------------------------------------------------------

    private Hashtable meta;
    private String hash;
    private String mime;
    private String path;
    private long size;

    //~ Constructors -----------------------------------------------------------

    /**
     * Constructor for ShareItemEvent.
     */
    public ShareItemEvent() {
        super();
        meta = new Hashtable();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * Sets the hash.
     *
     * @param hash The hash to set
     */
    public void setHash(String hash) {
        this.hash = hash;
    }

    /**
     * Returns the hash.
     *
     * @return String
     */
    public String getHash() {
        return hash;
    }

    /**
     * Returns the meta object specified by name
     *
     * @param name
     *
     * @return meta object
     */
    public Object getMetaItem(String name) {
        return meta.get(name);
    }

    /**
     * Returns all meta tags
     *
     * @return all meta tag names
     */
    public Enumeration getMetaTags() {
        return meta.elements();
    }

    /**
     * Sets the mime type.
     *
     * @param mime The mime to set
     */
    public void setMime(String mime) {
        this.mime = mime;
    }

    /**
     * Returns the mime type.
     *
     * @return String
     */
    public String getMime() {
        return mime;
    }

    /**
     * Sets the path.
     *
     * @param path The path to set
     */
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * Returns the path.
     *
     * @return String
     */
    public String getPath() {
        return path;
    }

    /**
     * Sets the size.
     *
     * @param size The size to set
     */
    public void setSize(long size) {
        this.size = size;
    }

    /**
     * Returns the size.
     *
     * @return long
     */
    public long getSize() {
        return size;
    }

    /**
     * Adds a meta object
     *
     * @param name
     * @param item
     */
    public void addMetaItem(String name, Object item) {
        meta.put(name, item);
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return path + "@SharesItemEvent";
    }
}
