/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.net;

import xnap.net.AbstractSearchResult;
import xnap.net.IDownload;
import xnap.net.IUser;

import xnap.plugin.gift.Plugin;

import xnap.util.DownloadQueue;
import xnap.util.SearchFilter;

import java.io.File;

import java.util.Hashtable;


/**
 * SearchResult
 * <pre>Metainfo for mp3:
 * 		- album
 * 		- artist
 * 		- duration
 * 		- bitrate
 * 		- frequency
 * 		- title
 * 		- tracknumber
 * 	</pre>
 *
 * @author <a href="mailto:tvanlessen@taval.de">Tammo van Lessen</a>
 * @version CVS $Id: SearchResult.java,v 1.15 2003/01/19 00:46:33 taval Exp $
 */
public class SearchResult extends AbstractSearchResult {
    //~ Instance fields --------------------------------------------------------

    private Hashtable meta;
    private String mime;
    private String node;
    private String url;

    //~ Constructors -----------------------------------------------------------

    /**
     * Constructor for SearchResult.
     *
     * @param size
     * @param user
     * @param filename
     * @param hash
     * @param node
     * @param mime
     * @param url
     * @param score
     * @param meta
     */
    public SearchResult(long size, IUser user, String filename, String hash,
        String node, String mime, String url, int score, Hashtable meta) {
        super(size, -1, -1, -1, user, filename, hash, Plugin.getInstance());
        this.node = node;
        this.mime = mime;
        this.url = url;
        this.meta = meta;

        //TODO: may be the wrong values
        //this.score = score;
        
        // try to extract meta tags 'bitrate', 'frequency', 'lenght'
        try {
            // remove "kpbs"
            String rate = ((String) meta.get("bitrate"));
            rate = rate.substring(0, rate.length() - 4);
            this.bitrate = Integer.parseInt(rate);
        } catch (Exception e) {
        }

        //
        try {
            // remove "s"
            String duration = ((String) meta.get("duration"));
            duration = duration.substring(0, duration.length() - 1);
            this.length = Integer.parseInt(duration);
        } catch (Exception e) {
        }

        //
        try {
            // remove "Hz"
            String freq = ((String) meta.get("frequency"));
            freq = freq.substring(0, freq.length() - 2);
            this.frequency = Integer.parseInt(freq);
        } catch (Exception e) {
        }
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * @see xnap.net.ISearchResult#getDownload()
     */
    public IDownload getDownload() {
        return null;//new Download(this);
    }

    /**
     * Returns the meta.
     *
     * @return Hashtable
     */
    public Hashtable getMeta() {
        return meta;
    }

    /**
     * Returns the mime-type.
     *
     * @return String
     */
    public String getMimeType() {
        return mime;
    }

    /**
     * Returns the node.
     *
     * @return String
     */
    public String getNode() {
        return node;
    }

    /**
     * @see xnap.net.ISearchResult#getShortFilename()
     */
    public String getShortFilename() {
        return filename.substring(filename.lastIndexOf("/") + 1);
    }

    /**
     * Returns the url.
     *
     * @return String
     */
    public String getUrl() {
        return url;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean canGroup() {
        return false;
    }

    /**
     * DOCUMENT ME!
     *
     * @param filter DOCUMENT ME!
     * @param file DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean download(SearchFilter filter, File file) {
        /*DownloadContainer d = new DownloadContainer(getFilename(), getHash(),
                getFilesize(), 0, "Active");
		return DownloadQueue.getInstance().add(d); */
        Engine.getInstance().addDownload(this);
        return true;
        
    }
}
