/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.net;

import java.io.IOException;

import xnap.net.AbstractSearch;
import xnap.plugin.gift.net.event.SearchControlEvent;
import xnap.plugin.gift.net.event.SearchItemEvent;
import xnap.plugin.gift.net.event.listener.SearchEventListener;
import xnap.util.SearchFilter;


/**
 * Search
 *
 * @author <a href="mailto:tvanlessen@taval.de">Tammo van Lessen</a>
 * @version CVS $Id: Search.java,v 1.9 2003/01/19 01:59:45 taval Exp $
 */
public class Search extends AbstractSearch implements SearchEventListener {
    //~ Constructors -----------------------------------------------------------

    /**
     * Constructor for Search.
     *
     * @param filter
     * @param priority
     * @param maxResults
     */
    public Search(SearchFilter filter, int priority, int maxResults) {
        super(filter, priority, maxResults);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * @see xnap.net.ISearch#close()
     */
    public void close() {
    	Engine.getInstance().changeSearch(this,"cancel");
    }

    /**
     * @see xnap.net.ISearch#connect()
     */
    public void connect() throws IOException {
    	Engine.getInstance().search(this);
    }

	/**
	 * @see xnap.plugin.gift.net.event.listener.SearchEventListener#searchFinished(xnap.plugin.gift.net.event.SearchControlEvent)
	 */
	public void searchFinished(SearchControlEvent evt) {
		finished = true;
	}

	/**
	 * @see xnap.plugin.gift.net.event.listener.SearchEventListener#searchItemReceived(xnap.plugin.gift.net.event.SearchItemEvent)
	 */
	public void searchItemReceived(SearchItemEvent evt) {
		add(evt.getSearchResult());
	}

	/**
	 * @see xnap.plugin.gift.net.event.listener.SearchEventListener#searchStarted(xnap.plugin.gift.net.event.SearchControlEvent)
	 */
	public void searchStarted(SearchControlEvent evt) {
	}


	/**
	 * @see xnap.plugin.gift.net.event.listener.SearchEventListener#getSearchFilter()
	 */
	public SearchFilter getSearchFilter() {
		return filter;
	}

}
