/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin;

import xnap.util.StringHelper;

import java.util.*;

public class PluginInfo
{

    //--- Constant(s) ---

    public static final int TYPE_PLUGIN = 1;
    public static final int TYPE_LAF = 2;

    //--- Data field(s) ---

    protected String[] classNames;
    protected String[] depends;
    protected String description;
    protected boolean installed = false;
    protected String filename;
    protected boolean loaded = false;
    protected String name;
    protected String version;
    protected String location;
    protected int type;
    protected String requires;
    protected String id;

    //--- Constructor(s) ---

//      public PluginInfo(String name, String version, String description, 
//  		      String location, String filename, int type)
//      {
//  	this.name = name;
//  	this.version = version;
//  	this.description = description;
//  	this.location = location;
//  	this.filename = filename;
//  	this.type = type;
//      }

    public PluginInfo(String id, Properties p)
    {
	this.id = id;
	this.name = p.getProperty(id + ".name", "");
	this.version = p.getProperty(id + ".version", "");
	this.description = p.getProperty(id + ".description", "");
	this.filename = p.getProperty(id + ".filename", "");
	String type = p.getProperty(id + ".type", "");
	if (type.equals("laf")) {
	    this.type = TYPE_LAF;
	}
	else {
	    this.type = TYPE_PLUGIN;
	}
	this.classNames 
	    = StringHelper.toArray(p.getProperty(id + ".classes", ""), ";");
	this.depends 
	    = StringHelper.toArray(p.getProperty(id + ".depends", ""), ";");
	this.requires = p.getProperty(id + ".requires", "");
    }
    
//      public PluginInfo()
//      {
//      }

    //--- Method(s) ---

    public String getClassName()
    {
	if (classNames.length > 0) {
	    return classNames[0];
	}
	else {
	    return null;
	}
    }

    public String[] getClassNames()
    {
	return classNames;
    }
    
    public String[] getDepends()
    {
	return depends;
    }
    
    public String getDescription()
    {
	return description;
    }

    public void setDescription(String newValue)
    {
	description = newValue;
    }

    public String getFilename()
    {
	return filename;
    }

    public void setFilename(String newValue)
    {
	filename = newValue;
    }

    public boolean isInstalled()
    {
	return installed;
    }

    public void setInstalled(boolean newValue)
    {
	installed = newValue;
    }

    public boolean isLoaded()
    {
	return loaded;
    }

    public void setLoaded(boolean newValue)
    {
	loaded = newValue;
    }

    public String getLocation()
    {
	return location;
    }

    public void setLocation(String newValue)
    {
	location = newValue;
    }

    public String getName()
    {
	return name;
    }

    public void setName(String newValue)
    {
	name = newValue;
    }

    public String getRequires()
    {
	return requires;
    }

    public int getType()
    {
	return type;
    }

    public String getVersion()
    {
	return version;
    }

    public void setVersion(String newValue)
    {
	version = newValue;
    }

    public boolean isValid()
    {
	return name != null && location != null && version != null;
    }

    public String toString()
    {
	return getName();
    }

}
