/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin;

import xnap.cmdl.*;
import xnap.net.*;
import xnap.util.*;

import java.util.*;

/**
 * Each plugin will only be instantiated once.
 */
public interface IPlugin
{

    //--- Method(s) ---

    /**
     * Returns a description of plugin.
     */
    String getDescription();

    /**
     * Returns the name of the plugin.
     */
    String getName();

    /**
     * Returns the version of the plugin. This should be something like
     * x.y. 
     */
    String getVersion();

    /**
     * Plugin is ready to serve requests.
     */
    boolean isEnabled();

    /**
     * Called each time the plugin is enabled.
     */
    void start();

    /**
     * Called each time the plugin is disabled.
     */
    void stop();

}
