/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin;

import xnap.net.*;
import xnap.util.*;

public interface INetworkPlugin extends IPlugin
{
    
    //--- Constant(s) ---

    int STATUS_GREEN = 1;
    int STATUS_RED = 2;

    //--- Method(s) ---

    /**
     * Returns the status of the plugin. For now this is only used by the 
     * StatusPanel.
     */
    int getStatus();

    /**
     * Returns a short string describing the status of the plugin. For 
     * now this is only used by the StatusPanel.
     */
    String getStatusMessage();

    /**
     * Returns an array of search objects. The searches are started by the 
     * SearchManager at some point. 
     *
     * @param filter   contains search parameters
     * @param priority search priority
     * @see xnap.net.ISearch
     */
    ISearch[] search(SearchFilter filter, int priority);

}







