/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net;

import xnap.XNap;

import java.io.*;
import java.net.*;
import java.util.*;
import org.apache.log4j.Logger;

public class NetHelper
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    //private static Logger logger = Logger.getLogger(NetHelper.class);

    //--- Constructor(s) ---

    //--- Method(s) ---

    public static Socket connect(String host, int port, long timeout)
	throws IOException
    {
	SocketConnector runner = new SocketConnector(host, port);
	Thread t = new Thread(runner, "SocketRunner " + host + ":" + port);
	t.start();

	return runner.getSocket(timeout);
    }

    //--- Inner Class(es) ---

    public static class SocketConnector implements Runnable
    {

	String host;
	int port;
	Socket socket;
	boolean done = false;
	IOException exception;
	
	public SocketConnector(String host, int port)
	{
	    this.host = host;
	    this.port = port;

	    this.socket = null;
	}

	public synchronized Socket getSocket(long timeout) throws IOException
	{
	    if (!done) {
		try {
		    this.wait(timeout);
		}
		catch (InterruptedException e) {
		}
	    }

	    if (exception != null) {
		throw (exception);
	    }
	    else if (socket == null) {
		throw new IOException(XNap.tr("Socket timeout"));
	    }
	    else {
		return socket;
	    }
	}

	public void run()
	{
	    try {
		socket = new Socket(host, port);
	    }
	    catch (IOException e) {
		this.exception = e;
	    }

	    synchronized (this) {
		done = true;
		this.notify();
	    }
	}

    }

}
