/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.net;

import java.io.IOException;

public interface IDownload extends ITransfer {

    //--- Constant(s) ---

    int SOCKET_TIMEOUT = 1 * 1000;

    //--- Method(s) ---

    /**
     * This is not used, yet.
     *
     * @return number of bytes available for read without blocking.
     */
    int available() throws IOException;

    /**
     * Closes the connection.
     */
    void close();

    /**
     * Initializes a connection. If an exception is thrown the connect
     * will not be retried.
     *
     * @param offset byte offset to start download from
     * @return true, if connect was successful, false, if remotely queued,
     *         can be retried later.
     */
    boolean connect(long offset) throws IOException;

    /**
     * 
     */
    void dequeue();

    /**
     * Sends command to enqueue download in peer's upload queue. This must me
     * implemented in a non-blocking way.
     */
    void enqueue(IDownloadContainer idc);

    /**
     * Reads b.length() bytes.
     */
    int read(byte[] b, int offset, int length) throws IOException;

    int getQueuePos();

    IDownloadContainer getParent();
    
    void setParent(IDownloadContainer parent);

    /**
     * Returns the time of the last try.
     */
    long getLastTry();

    /**
     * Returns the number of tries for this download.
     */
    int getTryCount();

    /**
     * Reset try counters.
     */
    void reset();

}
