/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.io;

import java.io.*;

public class ThrottledInputStream extends FilterInputStream {

    // --- Data Field(s) ---

    private static ThrottleSupport ts = new ThrottleSupport();
	
    // --- Constructor(s) ---

    public ThrottledInputStream(InputStream in) 
    {
	super(in);
    }
	
    // --- Method(s) ---

    public static void setBandwidth(long newValue)
    {
	ts.setBandwidth(newValue);
    }
	
    public int read(byte[] b, int off, int len) throws IOException 
    {
	len = ts.allocate(len);
	return len > 0 ? in.read(b, off, len) : len;
    }
}
