/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.table;

import xnap.util.*;

import java.util.*;

import java.awt.event.*;
import javax.swing.JTable;
import javax.swing.event.*;
import javax.swing.table.*;
import java.beans.*;

public class SortableTableModel extends AbstractSortableTableModel 
    implements TableModelListener
{

    //--- Data field(s) ---

    protected AbstractTableModel model = null;

    //--- Constructor(s) ---

    public SortableTableModel(AbstractTableModel model, 
			      boolean maintainSortOrder)
    {
	super(maintainSortOrder);

        setModel(model);
    }
    
    public SortableTableModel(AbstractTableModel model)
    {
	this(model, false);
    }

    //--- Method(s) ---

    public boolean isCellEditable(int row, int column)
    {
	return model.isCellEditable(row, column);
    }

    public Class getColumnClass(int columnIndex)
    { 
	return model.getColumnClass(columnIndex);
    }

    public int getColumnCount()
    {
	return model.getColumnCount();
    }

    public String getColumnName(int col) 
    { 
	return model.getColumnName(col); 
    }

    public AbstractTableModel getModel()
    {
	return model;
    }

    public void setModel(AbstractTableModel newValue) 
    {
	if (model != null) {
	    model.removeTableModelListener(this);
	}

        model = newValue;
	model.addTableModelListener(this);
        reallocateIndexes();
    }

    public int getRowCount()
    {
	return model.getRowCount();
    }

    /*
     * The mapping only affects the contents of the data rows.
     * Pass all requests to these rows through the mapping array: "indexes".
     *
     */
    public Object get(int row, int column) 
    {
	return model.getValueAt(row, column);
    }

    public void set(Object value, int row, int column) 
    {
	model.setValueAt(value, row, column);
    }

    public void tableChanged(TableModelEvent e) 
    {
	fireTableChanged(e);
    }

}
