/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.table;

import xnap.gui.XNapFrame;
import xnap.util.Debug;

import java.awt.*;
import javax.swing.*;
import javax.swing.table.*;

public class ScoreCellRenderer extends DefaultTableCellRenderer {

    //--- Constant(s) ---

    public static int WIDTH = 10;

    //--- Data Field(s) ---

    public static Image img = null;

    static {
	ImageIcon icon = XNapFrame.getSmallIcon("ok.png");
	if (icon != null) {
	    img = icon.getImage().getScaledInstance(WIDTH, WIDTH, 
						    Image.SCALE_SMOOTH);
	}
    }

    int score = 0;

    //--- Constructor(s) ---

    public ScoreCellRenderer() 
    {
    }

    //--- Method(s) ---

    protected void setValue(Object value) 
    {
	if (value instanceof Integer) {
	    score = ((Integer)value).intValue() / 5 + 1;
	    
	    if (img == null) {
		value = score + "";
	    }
	    else {
		value = null;
	    }
	}

	super.setValue(value);
    }

    public void paintComponent(Graphics g) 
    {
	super.paintComponent(g);

	if (img != null) {
	    for (int i = 0; i < score; i++) {
		g.drawImage(img, 2 + i * WIDTH, 2, null);
	    }
	}
	else {
	    Debug.log("ScoreCellRenderer: no icon");
	}	    
    }

}
