/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui.prefs;

import xnap.XNap;
import xnap.gui.*;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class SearchPrefsPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---

    //private ValidatedTextField jteMaxSearchResults;
    private JCheckBox jcRemoveDuplicateResults;
    private JCheckBox jcFilterResults;
    private JCheckBox jcStoppingDownloads;
    private ValidatedTextField jteAutoSearchInterval;
    private EnableAction acLimitDownloadAttempts;
    private ValidatedTextField jtfMaxAutoSearches;

    //--- Constructor(s) ---

    public SearchPrefsPanel()
    {
	setLayout(new GridBagLayout());

	// max search results
//          GridBagHelper.addLabel
//  	    (this, XNap.tr("Max Search Results"));
//          jteMaxSearchResults = new ValidatedTextField
//  	    (prefs.getMaxSearchResults() + "", 5, 
//  	     ValidatedTextField.NUMBERS_INT);
//          GridBagHelper.add(this, jteMaxSearchResults, false);

	// search result options
        jcRemoveDuplicateResults = new JCheckBox
	    (XNap.tr("Remove duplicate search results", 1), 
	     prefs.getRemoveDuplicateResults());
	GridBagHelper.add(this, jcRemoveDuplicateResults);

	jcFilterResults = new JCheckBox
            (XNap.tr("Double filter results", 1), prefs.getFilterResults());
	GridBagHelper.add(this, jcFilterResults);

	// auto downloads
	JPanel jpAutoDownloads = new JPanel(new GridBagLayout());
	jpAutoDownloads.setBorder(new 
	    TitledBorder(XNap.tr("Automatic Downloading", 1)));

        GridBagHelper.addLabel(jpAutoDownloads, 
			       XNap.tr("Search Interval (minutes)", 1));
        jteAutoSearchInterval = new ValidatedTextField
	    (prefs.getAutoDownloadSearchInterval() / 60 + "", 5, 
	     ValidatedTextField.NUMBERS_INT);
        GridBagHelper.add(jpAutoDownloads, jteAutoSearchInterval, false);

        jtfMaxAutoSearches = new ValidatedTextField
	    (prefs.getAutoDownloadMaxSearches() + "", 5, 
	     ValidatedTextField.NUMBERS_INT);
	acLimitDownloadAttempts
	    = new EnableAction(XNap.tr("Limit Search Attempts"),
			       new Component[] { jtfMaxAutoSearches },
			       prefs.getLimitDownloadAttempts());
	GridBagHelper.addComponent
	    (jpAutoDownloads, acLimitDownloadAttempts.getCheckBox());
	GridBagHelper.add(jpAutoDownloads, jtfMaxAutoSearches, false);
	
	GridBagHelper.add(this, jpAutoDownloads);

	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	//prefs.setMaxSearchResults(jteMaxSearchResults.getIntValue());
	prefs.setRemoveDuplicateResults(jcRemoveDuplicateResults.isSelected());
	prefs.setFilterResults(jcFilterResults.isSelected());
	prefs.setAutoDownloadSearchInterval
	    (jteAutoSearchInterval.getIntValue() * 60); 
	prefs.setLimitDownloadAttempts(acLimitDownloadAttempts.isSelected());
	prefs.setAutoDownloadMaxSearches(jtfMaxAutoSearches.getIntValue());
    }

    public Icon getIcon()
    {
	return XNapFrame.getIcon("find.png");
    }

    public String getTitle()
    {
	return XNap.tr("Search");
    }

}
