/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.prefs;

import xnap.XNap;
import xnap.gui.*;
import xnap.gui.text.EmacsKeyBindings;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class MiscPrefsPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---

    private ValidatedTextField jteMaxConsoleLines;
    private ValidatedTextField jteHistorySize;
    private JCheckBox jcShowIcons;
    private JCheckBox jcAutoVersionCheck;
    private JCheckBox jcEmacsKeyBindings;
    private JComboBox jcbLanguage;
    private JCheckBox jcbAutoCompletion;

    //--- Constructor(s) ---

    public MiscPrefsPanel()
    {
	setLayout(new GridBagLayout());

	JPanel jpSizes = new JPanel(new GridBagLayout());
	jpSizes.setBorder(new TitledBorder(XNap.tr("Number of Lines", 1)));

        GridBagHelper.addLabel(jpSizes, XNap.tr("Console"));
        jteMaxConsoleLines = new ValidatedTextField
	    (prefs.getMaxConsoleLines() + "", 5, 
	     ValidatedTextField.NUMBERS_INT);
        GridBagHelper.add(jpSizes, jteMaxConsoleLines, false);

        GridBagHelper.addLabel(jpSizes, XNap.tr("History"));
        jteHistorySize = new ValidatedTextField
	    (prefs.getSearchHistorySize() + "", 5, 
	     ValidatedTextField.NUMBERS_INT);
        GridBagHelper.add(jpSizes, jteHistorySize, false);

	GridBagHelper.add(this, jpSizes);

	JPanel jpMisc = new JPanel(new GridBagLayout());
	jpMisc.setBorder(new TitledBorder(XNap.tr("Miscellaneous", 1)));

	jcAutoVersionCheck = new JCheckBox(XNap.tr("Check for New Version", 1),
                                           prefs.getAutoVersionCheck());
	GridBagHelper.add(jpMisc, jcAutoVersionCheck);
	
        jcShowIcons = new JCheckBox(XNap.tr("Display Icons", 1), 
				    prefs.getShowIcons());
	GridBagHelper.add(jpMisc, jcShowIcons);

	jcEmacsKeyBindings = 
	    new JCheckBox(XNap.tr("Use Emacs Keybindings", 1),
			  prefs.getUseEmacsKeyBindings());
	jcEmacsKeyBindings.setToolTipText(XNap.tr("<html><table><tr><td width=\"200\">Enables the essential Emacs<br>keybindings to facilitate editing text.<br><small>(see FAQ for list of features)</small></td></tr></table></html>"));
	GridBagHelper.add(jpMisc, jcEmacsKeyBindings);

	jcbAutoCompletion = new JCheckBox(XNap.tr("Auto Completion",1),
					  prefs.getAutoComplete());
	jcbAutoCompletion.setToolTipText(XNap.tr("<html><table><tr><td width=\"200\">Activate completion of user input for all search fields which have a <b>history</b>.</td></tr></table></html>"));
	GridBagHelper.add(jpMisc, jcbAutoCompletion);

	GridBagHelper.add(this, jpMisc);

	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	prefs.setShowIcons(jcShowIcons.isSelected());
	prefs.setAutoVersionCheck(jcAutoVersionCheck.isSelected());
	prefs.setUseEmacsKeyBindings(jcEmacsKeyBindings.isSelected());
	prefs.setAutoComplete(jcbAutoCompletion.isSelected());
    }

    public Icon getIcon()
    {
	return XNapFrame.getIcon("gohome.png");
    }

    public String getTitle()
    {
	return XNap.tr("Misc");
    }

}



