/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.prefs;

import xnap.*;
import xnap.gui.*;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class FontPrefsPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---

    private FontPanel fpConsole;
    private ColorPanel cpConsoleBackground;
    private ColorPanel cpConsoleForeground;
    private FontPanel fpChat;
    private ColorPanel cpChatBackground;
    private ColorPanel cpChatMessage;
    private ColorPanel cpChatInfo;
    private ColorPanel cpChatError;
    private ColorPanel cpChatUser;

    //--- Constructor(s) ---

    public FontPrefsPanel()
    {
	setLayout(new GridBagLayout());

	// console panel
	JPanel jpConsole = new JPanel(new GridBagLayout());
	jpConsole.setBorder(new TitledBorder(XNap.tr("Console", 1)));

	GridBagHelper.addLabel(jpConsole, XNap.tr("Font"));
	fpConsole = new FontPanel(this, GUIHelper.getFont("console"));
	GridBagHelper.add(jpConsole, fpConsole);

	JPanel jpConsoleColorsLeft = new JPanel(new GridBagLayout());
	JPanel jpConsoleColorsRight = new JPanel(new GridBagLayout());

	GridBagHelper.addLabel(jpConsoleColorsLeft, XNap.tr("Background"));
	cpConsoleBackground 
	    = new ColorPanel(GUIHelper.getColor("consoleBackground"));
	GridBagHelper.add(jpConsoleColorsLeft, cpConsoleBackground);

	GridBagHelper.addLabel(jpConsoleColorsRight, 
			       XNap.tr("Foreground"));
	cpConsoleForeground 
	    = new ColorPanel(GUIHelper.getColor("consoleForeground"));
	GridBagHelper.add(jpConsoleColorsRight, cpConsoleForeground);
	
	JPanel jpConsoleColors = new JPanel(new GridLayout(1, 2));
	jpConsoleColors.setBorder
	    (new TitledBorder(XNap.tr("Colors", 1)));
	jpConsoleColors.add(jpConsoleColorsLeft);
	jpConsoleColors.add(jpConsoleColorsRight);
	GridBagHelper.add(jpConsole, jpConsoleColors);

	GridBagHelper.add(this, jpConsole);

	// chat panel
	JPanel jpChat = new JPanel(new GridBagLayout());
	jpChat.setBorder(new TitledBorder((XNap.tr("Chat", 1))));

	GridBagHelper.addLabel(jpChat,XNap.tr("Font"));
	fpChat = new FontPanel(this, GUIHelper.getFont("chat"));
	GridBagHelper.add(jpChat, fpChat);

	JPanel jpChatColorsLeft = new JPanel(new GridBagLayout());
	JPanel jpChatColorsRight = new JPanel(new GridBagLayout());

	GridBagHelper.addLabel(jpChatColorsLeft, XNap.tr("Background"));
	cpChatBackground = new ColorPanel(GUIHelper.getColor("chatBackground"));
	GridBagHelper.add(jpChatColorsLeft, cpChatBackground);

	GridBagHelper.addLabel(jpChatColorsRight, XNap.tr("Messages"));
	cpChatMessage = new ColorPanel(GUIHelper.getColor("chatMessage"));
	GridBagHelper.add(jpChatColorsRight, cpChatMessage);

	GridBagHelper.addLabel(jpChatColorsLeft, XNap.tr("Users"));
	cpChatUser = new ColorPanel(GUIHelper.getColor("chatUser"));
	GridBagHelper.add(jpChatColorsLeft, cpChatUser);

	GridBagHelper.addLabel(jpChatColorsRight, XNap.tr("Info"));
	cpChatInfo = new ColorPanel(GUIHelper.getColor("chatInfo"));
	GridBagHelper.add(jpChatColorsRight, cpChatInfo);

	GridBagHelper.addLabel(jpChatColorsLeft, XNap.tr("Errors"));
	cpChatError = new ColorPanel(GUIHelper.getColor("chatError"));
	GridBagHelper.add(jpChatColorsLeft, cpChatError);

	GridBagHelper.addVerticalSpacer(jpChatColorsRight);

	JPanel jpChatColors = new JPanel(new GridLayout(1, 2));
	jpChatColors.setBorder
	    (new TitledBorder(XNap.tr("Colors", 1)));
	jpChatColors.add(jpChatColorsLeft);
	jpChatColors.add(jpChatColorsRight);
	GridBagHelper.add(jpChat, jpChatColors);
	
	GridBagHelper.add(this, jpChat);

	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	GUIHelper.setFont("console", fpConsole.getSelectedFont());
	GUIHelper.setColor("consoleBackground", 
			   cpConsoleBackground.getSelectedColor());
	GUIHelper.setColor("consoleForeground", 
			   cpConsoleForeground.getSelectedColor());

	GUIHelper.setFont("chat", fpChat.getSelectedFont());
	GUIHelper.setColor("chatBackground", 
			   cpChatBackground.getSelectedColor());
	GUIHelper.setColor("chatMessage", cpChatMessage.getSelectedColor());
	GUIHelper.setColor("chatUser", cpChatUser.getSelectedColor());
	GUIHelper.setColor("chatInfo", cpChatInfo.getSelectedColor());
	GUIHelper.setColor("chatError", cpChatError.getSelectedColor());
    }

    public Icon getIcon()
    {
	return null;
    }

    public String getTitle()
    {
	return XNap.tr("Fonts");
    }

}
