/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.event;

import java.awt.datatransfer.*;
import java.io.*;
import java.util.*;
import org.apache.log4j.Logger;

public class TransferableFile implements Transferable
{

    //--- Constant(s) ---

    public static final DataFlavor FILE_FLAVOR =
	new DataFlavor(TransferableFile.class, "File Transferable");
    
    //--- Data field(s) ---

    protected FileArray fileArray;
    private static Logger logger = Logger.getLogger(TransferableFile.class);
    protected static DataFlavor flavors[] = { FILE_FLAVOR };

    //--- Constructor(s) ---

    public TransferableFile(File files[])
    {
	fileArray = new FileArray(files);
    }

    //--- Method(s) ---
 
    public Object getTransferData(DataFlavor flavor)
    	throws UnsupportedFlavorException, IOException
    {
	if (isDataFlavorSupported(flavor)) {
	    return fileArray;
	}
	else {
	    throw new UnsupportedFlavorException(flavor);
	}
    }


    public DataFlavor[] getTransferDataFlavors() 
    {
	return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor)
    {
	return flavor.equals(FILE_FLAVOR);
    }
}
