/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.event;

import xnap.XNap;
import xnap.gui.XNapFrame;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Shows or hides the options panel
 */
public class ShowAction extends AbstractAction {

    private Component c;
    private Component parent;

    public ShowAction(Component parent, Component c) 
    {
	this.parent = parent;
	this.c = c;

	update();
    }
	
    public void actionPerformed(ActionEvent event) 
    {
	c.setVisible(!c.isVisible());
	update();
	//parent.invalidate();
    }
	
    public void update()
    {
	Icon icon;
	String altText;
	if (c.isVisible()) {
	    putValue(Action.SHORT_DESCRIPTION, XNap.tr("Hide options"));
	    icon = XNapFrame.getSmallIcon("2uparrow.png");
	    altText = "/\\";
	}
	else {
	    putValue(Action.SHORT_DESCRIPTION, XNap.tr("Show options"));
	    icon = XNapFrame.getSmallIcon("2downarrow.png");
	    altText = "\\/";
	}

	if (icon != null) {
	    putValue(Action.SMALL_ICON, icon);
	}
	else {
	    putValue(Action.NAME, altText);
	}
    }
	
}

