/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.event;

import xnap.*;
import xnap.cmdl.Console;
import xnap.gui.*;
import xnap.util.*;
import xnap.util.launcher.LauncherSupport;

import java.awt.event.*;
import java.util.*;
import java.io.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.beans.*;


public class OpenFileAction extends AbstractAction 
    implements PropertyChangeListener
{
    
    //--- Constant(s) ---
    
    //--- Data field(s) ---
    
    private FileCollector fc;

    private Preferences prefs = Preferences.getInstance();
        
    protected String command;

    //--- Constructor(s) ---

    public OpenFileAction(FileCollector fc) 
    {
	this.fc = fc;
	
	putValue(Action.NAME, XNap.tr("Open"));
	putValue(Action.SHORT_DESCRIPTION, XNap.tr("Open selected files"));
	putValue(Action.SMALL_ICON, XNapFrame.getIcon("fileopen.png"));
	putValue(Action.MNEMONIC_KEY, new Integer('O'));

	setEnabled(LauncherSupport.isEnabled());
	prefs.addPropertyChangeListener("fileLauncherCmd", this);
	prefs.addPropertyChangeListener("fileLauncherType", this);
    }

    //--- Method(s) ---

    public void actionPerformed(ActionEvent event)
    {
	File[] files = fc.getFiles();
		
	if (files == null) {
	    return;
	}
	
	for (int i = 0; i < files.length; i++) {
	    if (files[i] == null || files[i].length() == 0) {
		continue;
	    }
	    
	    try {
		LauncherSupport.open(files[i]);
	    }
	    catch (IOException e) {
		Console.getInstance().println(e.getMessage());
	    }
	}
    }

    public void propertyChange(PropertyChangeEvent e)
    {
	setEnabled(LauncherSupport.isEnabled());
    }

}
