/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.event;

import xnap.XNap;

import java.awt.*;
import java.awt.dnd.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

import org.apache.log4j.Logger;

public class MouseDragAdapter extends MouseDragGestureRecognizer
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    private static Logger logger = Logger.getLogger(MouseDragAdapter.class);
    private int x;
    private int y;
    private MouseEvent event;

    //--- Constructor(s) ---

    public MouseDragAdapter(DragSource ds, Component c, int actions,
			    DragGestureListener dgl)
    {
	super(ds, c, actions, dgl);
    }

    //--- Method(s) ---

    public void mouseClicked(MouseEvent e)
    {

    }

    public void mouseDragged(MouseEvent e)
    {
	if (e.getX() < x - 10) {
	    if (event != null) {
		// FIX: this is an ugly work around, because dnd does not
		// seem to work with jdk1.3.1 / linux with drag events
		// it does not puke over MousePressed events though
		appendEvent(event);
		fireDragGestureRecognized(DnDConstants.ACTION_MOVE, 
					  new Point(e.getX(), e.getY()));
	    }
	}
    }

    public void mouseEntered(MouseEvent e)
    {

    }

    public void mouseExited(MouseEvent e)
    {

    }

    public void mouseMoved(MouseEvent e)
    {

    }

    public void mousePressed(MouseEvent e)
    {
	x = e.getX();
	y = e.getY();
	event = e;
    }

    public void mouseReleased(MouseEvent e)
    {
    }

}

