/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.action;

import xnap.XNap;
import xnap.gui.XNapFrame;
import xnap.gui.event.FileCollector;

import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 * 
 */
public class CutFileAction extends AbstractAction {
    
    //--- Constant(s) ---

    //--- Data field(s) ---

    FileCollector fc;

    //--- Constructor(s) ---

    public CutFileAction(FileCollector fc) 
    {
	this.fc = fc;

	putValue(Action.NAME, XNap.tr("Cut"));
	putValue(Action.SHORT_DESCRIPTION, XNap.tr("Move selected files."));
	putValue(Action.SMALL_ICON, XNapFrame.getIcon("editcut.png"));
    }

    //--- Method(s) ---
        
    public void actionPerformed(ActionEvent event) 
    {
	File[] files = fc.getFiles();
	if (files != null) {
	    FileActionManager.setFiles(files, FileActionManager.ACTION_MOVE);
	}
    }
    
}
