/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;

public class TitledPanel extends JPanel {
    
    //--- Data Field(s) ---

    JLabel jlTitle;

    //--- Constructor(s) ---

    public TitledPanel(String title, String description, Icon icon, 
		       JComponent c)
    {
	JPanel jpTop = new JPanel(new BorderLayout());
	jpTop.setBackground(Color.lightGray);
	jpTop.setBorder(new EtchedBorder());

	if (title != null) {
	    jlTitle = new JLabel(" " + title + " ");
	    if (icon != null) {
		jlTitle.setIcon(icon);
	    }
	    jpTop.add(jlTitle, "North");
	}

	if (description != null) {
	    MultiLineLabel jtaInfo = new MultiLineLabel(description);
  	    jtaInfo.setBorder(new EmptyBorder(2, 2, 2, 2));
	    jpTop.add(jtaInfo, "Center");
	}

	// spacer
	JPanel p = new JPanel(new BorderLayout());
	p.setBorder(new EmptyBorder(0, 0, 3, 0));
	p.add(jpTop, "Center");

	setLayout(new BorderLayout());
	add(p, "North");
	if (c != null) {
	    c.setBorder(new EtchedBorder());
	    add(c, "Center");
	}
    }

    public TitledPanel(String title, String description, JComponent c)
    {
	this(title, description, null, c);
    }

    public TitledPanel(JComponent c)
    {
	this(null, null, null, c);
    }

    //--- Method(s) ---

    public String getTitle()
    {
	return jlTitle.getText();
    }

    public void setTitle(String newValue)
    {
	jlTitle.setText(newValue);
    }

}

