/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui;

import xnap.*;
import xnap.gui.table.BrowseTableModel;
import xnap.gui.table.SearchTableModel;
import xnap.gui.tree.*;
import xnap.gui.util.GUIHelper;
import xnap.gui.util.SwingSynchronizedCache;
import xnap.io.*;
import xnap.net.*;
import xnap.net.event.*;
import xnap.plugin.*;
import xnap.util.*;
import xnap.util.event.*;

import org.apache.log4j.Logger;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.*;


public class SearchSubTreePanel extends SearchSubPanel 
    implements ListListener, TreeSelectionListener {

    //--- Constant(s) ---

    //--- Data field(s) ---

    private static Logger logger = Logger.getLogger(SearchSubTreePanel.class);

    protected JSplitPane jsp;
    protected JTree jtPath;
    protected DefaultTreeModel dtmPath;
    protected SearchPathNode spnRoot;
    private SwingSynchronizedCache cache;

    //--- Constructor(s) ---

    public SearchSubTreePanel(SearchPanel parent, ISearchContainer sc)
    {
	super(parent, sc);

	cache = new SwingSynchronizedCache(this);
	srCollector.getData().addListListener(cache);
    }
    
    //--- Method(s) ---

    protected void initialize()
    {
	super.initialize(false);

	// tree
	spnRoot = new SearchPathNode("All Files");
	dtmPath = new DefaultTreeModel(spnRoot);
	jtPath = new JTree(dtmPath);
	jtPath.addTreeSelectionListener(this);
	jtPath.setCellRenderer(new FileCellRenderer());
	jtPath.putClientProperty("JTree.lineStyle", "Angled");

	JScrollPane jspPath = new JScrollPane(jtPath);

	// split pane
	jsp = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
	jsp.setOneTouchExpandable(true);
	if (originalFilter == null) {
	    jsp.setDividerLocation(200);
	}
	else {
	    jsp.setDividerLocation(0);
	}

	jsp.add(jspPath, JSplitPane.LEFT);
	jsp.add(jspSearch, JSplitPane.RIGHT);

	// content
	add(jsp, BorderLayout.CENTER);
    }

    public void elementAdded(ListEvent event)
    {
	addToTree((ISearchResult)event.getElement());
	updateTitle();
    }

    public void addToTree(ISearchResult sr)
    {
	String[] path = sr.getPath();
	if (path != null) {
	    SearchPathNode node = spnRoot;
	    SearchPathNode nextNode;
	    // iterate through path and create new directories as needed
	    for (int i = 0; i < path.length; i++) {
		nextNode = null;

		// go through children
		int index = 0;
		for (;index < node.getChildCount(); index++) {
		    SearchPathNode n = (SearchPathNode)node.getChildAt(index);
		    int result = n.getName().compareToIgnoreCase(path[i]);
		    if (result == 0) {
			nextNode = n;
			break;
		    }
		    else if (result > 0) {
			index = node.getIndex(n);
			break;
		    }
		}

		if (nextNode == null) {
		    //logger.debug("SearchSubTree: adding " + path[i]);
		    
		    // add new child
		    nextNode = new SearchPathNode(path[i]);
		    
		    //logger.debug("adding new node at index " + index);
		    dtmPath.insertNodeInto(nextNode, node, index);

		    if (i == 0) {
			// we want to see the first depth level
			jtPath.expandRow(0);
		    }
		}
		node = nextNode;
	    }
	    node.incResultCount();
	}
    }

    public void elementRemoved(ListEvent e)
    {
	// should not happen
    }

    protected SearchTableModel createTableModel()
    {
	return new BrowseTableModel();
    }

    protected String getTableModelName()
    {
	return "browse";
    }

    public void valueChanged(TreeSelectionEvent e)
    {
	Object target = e.getPath().getLastPathComponent();
	
	if (target instanceof SearchPathNode) {
	    SearchPathNode s = (SearchPathNode)target;

	    SearchFilter filter = srCollector.getFilter();
	    if (filter == null) {
		filter = new SearchFilter();
	    }
	    filter.setPath(s.getSearchPath());
	    applyFilter(filter);
	}
    }
    
}

