/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import javax.swing.*;


/** 
 * This class uses a <tt>JTextArea</tt> to simulate a <tt>JLabel</tt> that 
 * allows multiple-line labels.  It does this by using JLabel's values for 
 * border, font, etc.
 */
public class MultiLineLabel extends JTextArea {

    /**
     * Creates a label that can have multiple lines and that has the 
     * default width.
     *
     * @param s the <tt>String</tt> to display in the label
     */
    public MultiLineLabel(String s) 
    {
	setEditable(false);
	setLineWrap(true);
	setWrapStyleWord(true);
	setHighlighter(null);
	LookAndFeel.installBorder(this, "Label.border");
	LookAndFeel.installColorsAndFont(this, "Label.background",
					 "Label.foreground", "Label.font");
	setSelectedTextColor(UIManager.getColor("Label.foreground"));
	setText(s);
    }

    public MultiLineLabel() 
    {
	this(" ");
    }

}
