/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui;

import xnap.*;
import xnap.net.*;
import xnap.util.*;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import javax.swing.*;
import javax.swing.border.*;

public class HTMLDialog extends DefaultDialog {
    
    //--- Data field(s) ---

    private HTMLEditorPane htmlPane;

    //--- Constructor(s) ---
    
    private HTMLDialog(String title) 
    {
	super(BUTTON_CLOSE);

	/* text panel */
	htmlPane = new HTMLEditorPane();

	JScrollPane jsp = new JScrollPane(htmlPane);
	jsp.setPreferredSize(new Dimension(400, 400));

	/* content */
        setTitle(title);
	getMainPanel().setLayout(new BorderLayout());
	getMainPanel().add(jsp, BorderLayout.CENTER);
        pack();
    }

    // --- Methods ---

    public static void showDialog(final Component c, final String title,
				  final String location)
    {
	(new Thread("ShowHTMLFile " + location) 
	    {
		public void run()
		{
		    HTMLDialog me = new HTMLDialog(title);
		    if (c != null) {
			me.setLocationRelativeTo(c);
		    }

		    URL url;
		    try {
			url = new URL(location);
			me.htmlPane.setPage(location);
		    }
		    catch (IOException e) {
			me.htmlPane.setText
			    (XNap.tr("Error:") + e.getMessage());
		    }
		    
		    me.show();
		}
	    }).start();
    }

}

