/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui;

import xnap.XNap;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;

/**
 * Provides a panel with a <code>JTextField</code> and a button for file
 * selection.
 */
public class FilePanel extends JPanel {
    
    //--- Data field(s) ---

    private JTextField jtfFilename;

    //--- Constructor(s) ---

    public FilePanel(String text, int size) 
    {
	setLayout(new BoxLayout(this, BoxLayout.X_AXIS));

	jtfFilename = new JTextField(text, size);
	add(jtfFilename);

	add(Box.createHorizontalStrut(1));

	JButton jbChooser = new JButton(new FileChooserAction());
	jbChooser.setMargin(new Insets(1, 1, 1, 1));
	add(jbChooser);
    }

    /**
     * Sub classes can overwrite this.
     */
    protected void filenameSelected(String dir)
    {
    }

    public String getFilename()
    {
	return jtfFilename.getText();
    }

    public void setFilename(String dir)
    {
	jtfFilename.setText(dir);
    }

    public JTextField getTextField()
    {
	return jtfFilename;
    }

    // --- Inner Class(es) ---

    private class FileChooserAction extends AbstractAction {
	
	JFileChooser chooser;

        public FileChooserAction() 
	{
	    chooser = new JFileChooser();
	    chooser.setApproveButtonText(XNap.tr("OK"));
	    chooser.setDialogTitle(XNap.tr("Choose File"));

	    putValue(Action.SMALL_ICON, 
		     XNapFrame.getSmallIcon("fileopen.png"));
            putValue(Action.SHORT_DESCRIPTION, XNap.tr("Choose a file") );
	}

        public void actionPerformed(ActionEvent event) 
	{
	    chooser.setSelectedFile(new File(getFilename()));
	    
	    if (chooser.showSaveDialog(FilePanel.this) 
		== JFileChooser.APPROVE_OPTION) {
		String filename = chooser.getSelectedFile().getAbsolutePath();
		setFilename(filename);
		filenameSelected(filename);
	    }
	}
    } 

}
