/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.*;
import xnap.cmdl.*;
import xnap.util.*;
import xnap.util.event.*;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.border.*;
import org.apache.log4j.*;

public class DebugPanel extends JPanel {

    //--- Constant(s) ---

    /**
     * Buffer 512 byte for debug log.
     */
    public static final int BUFFER_SIZE = 512;
    
    //--- Data field(s) ---
    
    private static Preferences prefs = Preferences.getInstance();

    private JTextField jtfLayout;
    private JComboBox jcbLevel;
    private JCheckBox jcbLogToFile;
    private FilePanel fpFilename;
    private JCheckBox jcbLogToConsole;
    private ConsolePane cpDebug;

    private FileAppender apFile;
    private WriterAppender apConsole;
    private PatternLayout layout = new PatternLayout(); 

    private Level[] levels = {
	Level.ALL, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, 
    };
    
    //--- Constructor(s) ---
    
    public DebugPanel()
    {
	setLayout(new GridBagLayout());

	GridBagHelper.addLabel(this, XNap.tr("Level"));
	jcbLevel = new JComboBox(levels);
	GridBagHelper.add(this, jcbLevel, false);

	GridBagHelper.addLabel(this, XNap.tr("Layout"));
	jtfLayout = new JTextField("[%-15c{1}] [%-20.20t] %m%n");
	GridBagHelper.add(this, jtfLayout);

	jcbLogToFile = new JCheckBox(XNap.tr("Log To File"));
	GridBagHelper.addComponent(this, jcbLogToFile);
	
	fpFilename = new FilePanel(prefs.getDebugLogFile(), 20);
	GridBagHelper.add(this, fpFilename);

	EnableAction acLogToFile = new EnableAction
	    (new Component[] { fpFilename }, jcbLogToFile);

	jcbLogToConsole = new JCheckBox(XNap.tr("Log To Console"));
	GridBagHelper.add(this, jcbLogToConsole);

	cpDebug = new ConsolePane(false);
	cpDebug.setBorder(new TitledBorder(XNap.tr("Debug Console")));
	GridBagHelper.addPanel(this, cpDebug);
    }

    // --- Methods ---

    /**
     * Activates the selected debug settings.
     */
    public void apply()
    {
	boolean hasChanged 
	    = !layout.getConversionPattern().equals(jtfLayout.getText());

	Logger.getRootLogger().setLevel((Level)jcbLevel.getSelectedItem());
	layout.setConversionPattern(jtfLayout.getText());
	
	if (jcbLogToFile.isSelected()) {
	    if (apFile == null
		|| apFile.getFile() != fpFilename.getFilename()) {
		close(apFile);
		
		try {
		    apFile = new FileAppender(layout, fpFilename.getFilename(),
					      false, true, BUFFER_SIZE);
		    Logger.getRootLogger().addAppender(apFile);
		}
		catch (IOException e) {
		    Dialogs.error(this, e.getLocalizedMessage());
		}
	    }
	}
	else if (apFile != null) {
	    // file logging has been deselected
	    close(apFile);
	    apFile = null;
	}
	
	if (jcbLogToConsole.isSelected()) {
	    if (apConsole == null || hasChanged) {
		close(apConsole);

		apConsole 
		    = new WriterAppender(layout, new ConsoleOutputStream());
		apConsole.setLayout(layout);
		Logger.getRootLogger().addAppender(apConsole);
	    }
	}
	else if	(apConsole != null) {
	    // console logging has been deselected
	    close(apConsole);
	    apConsole = null;
	}
    }

    private void close(WriterAppender ap)
    {
	if (ap != null) {
	    ap.close();
	    Logger.getRootLogger().removeAppender(ap);
	}
    }

    /**
     * Buffered stream for console panel. 
     */
    private class ConsoleOutputStream extends OutputStream
    {

	private StringBuffer buffer = new StringBuffer();

	public void flush() 
	{
	    cpDebug.appendLater(buffer.toString());
	    buffer.setLength(0);
	}

	public void write(int b) 
	{
	    buffer.append((char)b);
	    if (b == '\n') {
		flush();
	    }
	}

    }

}
