/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.*;
import xnap.net.*;
import xnap.util.*;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.util.*;
import javax.accessibility.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.*;


public class CloseableTabbedPane extends JTabbedPane {
    
    //--- Data field(s) ---

    protected ImageIcon closingIcon;
    
    //--- Constructor(s) ---
    
    public CloseableTabbedPane(ImageIcon closingIcon) 
    {
	this.closingIcon = closingIcon;

	addMouseListener(new ClosingListener());
    }
    
    public CloseableTabbedPane() 
    {
	this(XNapFrame.getSmallIcon("remove.png"));
    }

    //--- Method(s) ---

    public void addTab(String title, Component component, boolean closeable) 
    {
  	if (closeable) {
  	    super.addTab(title, new ClosingIcon(closingIcon), component);
	}
  	else {
  	    super.addTab(title, component);
	}
	setSelectedComponent(component);
    }

    public void addTab(String title, Component component) 
    {
	addTab(title, component, true);
    }

    //--- Inner Class(es) ---

    protected class ClosingListener extends MouseAdapter
    {
	
	public void mouseReleased(MouseEvent e)
	{
	    int i = getSelectedIndex();
	    
	    // nothing selected
	    if (i == -1)
		return;
	    
	    ClosingIcon icon = (ClosingIcon)getIconAt(i);
	    
	    // close tab, if icon was clicked
	    if (icon != null && icon.contains(e.getX(), e.getY())) {
		removeTabAt(i);
	    }
	}
	
    }

    /**
     * the idea for this class stems from limewire's CancelSearchIconProxy
     * class, thanks for going open source guys.
     */
    protected class ClosingIcon implements Icon
    {

	//--- Data field(s) ---

	private Icon icon;    
	private int x = 0;
	private int y = 0;
	private int height = 10;
	private int width = 10;

	//--- Constructor(s) ---
	
	public ClosingIcon(ImageIcon icon)
	{
	    this.icon = icon;

	    if (icon != null) {
		height = icon.getIconHeight();
		width = icon.getIconWidth();
	    }
	}
	
	//--- Method(s) ---

	/**
	 *
	 */
	public int getIconHeight()
	{
	    return height;
	}

	/**
	 * 
	 */
	public int getIconWidth()
	{
	    return width;
	}

	/**
	 * Overwrites paintIcon to get hold of the coordinates of the icon,
	 * this is a rather rude approach just to find out if the closingIcon
	 * was pressed.
	 */
	public void paintIcon(Component c, Graphics g, int x, int y)
	{
	    this.x = x;
	    this.y = y;
	    
	    if (icon != null) {
		icon.paintIcon(c, g, x, y + 1);
	    }
	    else {
		Debug.log("CloseableTabbedPane: no icon");
		g.drawRect(x, y + 1, width, height);
	    }
	}    
	
	/**
	 * Verifies if x and y are within the icon's borders.
	 */
	public boolean contains(int xEvent, int yEvent)
	{
	    if (!(xEvent >= x) || !(xEvent <= x + width)) {
		return false;
	    }
	    if (!(yEvent >= y) || !(yEvent <= y + height)) {
		return false;
	    }

	    return true;
	}
    }
    
}
