/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.gui.action.ActionSupport;
import xnap.util.event.StatusListener;
import xnap.util.Preferences;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 * Panels shown in the main window should inherit this class. 
 *
 * <code>StatusListener</code> is implemented as a convenience for 
 * containers with child panels (like JTabbedPane), so status events
 * can be chained through.
 */
public abstract class AbstractPanel extends JPanel 
    implements ActionSupport, StatusListener {

    //--- Data field(s) ---
    
    /**
     * Convienence varible.
     */
    protected static Preferences prefs = Preferences.getInstance();

    private StatusListener listener;

    //--- Constructor(s) ---

    public AbstractPanel() 
    {
    }

    //--- Method(s) ---

    /**
     * Sub classes should reimplement this.
     */
    public AbstractAction[] getActions()
    {
	return null;
    }

    /**
     * Sets the status in the global status bar.
     */
    public void setStatus(String newValue) 
    {
	if (listener != null) {
	    listener.setStatus(newValue);
	}
    }

    /**
     * Called by <code>XNapFrame</code> to register itself as the status
     * listener.
     */
    public void setStatusListener(StatusListener newValue) 
    {
	listener = newValue;
    }

    
}
