/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/*
 * This is a wrapper class for JavaReadline and the GNU Readline library.
 *
 */
package xnap.cmdl;

import xnap.util.Debug;
import xnap.util.FileHelper;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import org.gnu.readline.*;

public class ReadlineConsole implements IConsole {

    // --- Data Field(s) ---

    private File history = new File(FileHelper.getHomeDir() + "history");

    // --- Constructor(s) ---

    public ReadlineConsole()
    {
	try {
	    Readline.load(ReadlineLibrary.GnuReadline);
	} 
	catch (UnsatisfiedLinkError e1) {
	    try {
		Readline.load(ReadlineLibrary.Editline);
	    } 
	    catch (UnsatisfiedLinkError e2) {
	    }
	}
	
	try {
	    Readline.initReadline("XNap");
	} 
	catch (UnsatisfiedLinkError e) {
	    System.err.println
		("Ooops, your Java-Readline Library seems broken. "
		 + "Using pure java.");
	    Readline.load(ReadlineLibrary.PureJava);
	    Readline.initReadline("XNap");
	}
	
	Readline.initReadline("XNap");
	Readline.setCompleter(new ReadlineCompleter());
	
	try {
	    if (history.exists()) {
		Readline.readHistoryFile(history.getAbsolutePath());
	    }
	} 
	catch (Exception e) {
	}
    }

    // --- Method(s) ---

    public boolean isEchoing()
    {
	return true;
    }

    /**
     * Display a prompt on standard output and read a string from
     * standard input.
     *
     * @param prompt Prompt to display
     * @return The string the user entered
    */
    public String readLine(String prompt)
    {
	try {
	    String s = Readline.readline(prompt);
	    return (s == null ? "" : s);
	} 
	catch (EOFException e) {
	} 
	catch (IOException e) {
	}

	return null;
    }


    /**
     * Prints to stdout.
     *
     * @param output Text to show
     */
    public void printLine(String output)
    {
	System.out.print(output);
    }

    /**
     * This should be called when the application is closed.
     *
     */
    public void saveSettings()
    {
	try {
	    Readline.writeHistoryFile(history.getAbsolutePath());
	} catch (Exception e) {
	}
    }

    /**
     * Set your completer function.
     *
     * @param rlc An object implementing the ReadlineCompleter interface
     */
    public Completer getCompleter() 
    {
	return (ReadlineCompleter)Readline.getCompleter();
    }

}
