/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
import java.io.*;
import java.util.*;

public class I18nToResource {

    /**
     * 
     */
    public static void main(String[] argv)
    {
	if (argv.length != 2) {
	    System.err.println("usage: I18nToResource i18nfile resourcefile");
	    System.exit(1);

	}

	HashSet keys = Helper.readKeys();

	try {
	    System.out.println(argv[0] + " -> " + argv[1]);
	    write(argv[0], argv[1], keys);
	}
	catch (IOException e) {
	    System.err.println("Error: " + e.getMessage());
	    System.exit(1);
	}
    }

    public static void write(String source, String dest, HashSet keys)
	throws IOException
    {
	Hashtable table = Helper.readI18nFile(source, true);

	Properties props = new Properties();
	for (Iterator i = table.keySet().iterator(); i.hasNext();) {
	    String key = (String)i.next();
	    if (keys.contains(key)) {
		String value = Helper.rawToJava(table.get(key).toString());
		key = Helper.rawToJava(key);
		props.put(key, value);
	    }
	}

	FileOutputStream out = new FileOutputStream(new File(dest));
	props.store(out, "Generated by I18nToResource. Don't edit manually. "
		    + "Use files in i18n directory instead.");
	out.close();
    }

}

    
