/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
import java.io.*;
import java.util.*;

public class ConvertString {

    public static boolean quiet;

    /**
     * usage: ConvertResource
     */
    public static void main(String[] argv)
    {
	try {
	    if (argv.length == 0) {
		quiet = false;
	    }
	    else if (argv.length == 1 && argv[0].equals("-q")) {
		quiet = true;
	    }
	    else {
		System.err.println("usage: ConvertResource [-q]");
	    }

	    BufferedReader in 
		= new BufferedReader(new InputStreamReader(System.in));

	    Properties dests = new Properties();

	    if (!quiet) { System.out.print("> "); }
	    String s;
	    while ((s = in.readLine()) != null) {
		dests.put(s, s);
		if (!quiet) {
		    dests.store(System.out, "");
		    System.out.println("");
		    System.out.print("> ");
		}
	    }

	    if (quiet) {
		// output everything at once
		dests.store(System.out, "Converted by ConvertString");
	    }
	}
	catch (IOException e) {
	    System.err.println("Error: " + e.getMessage());
	    System.exit(1);
	}
    }

}
