/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
//package xnap.plugin.nap.net;

import xnap.plugin.nap.net.ServerVersion;

import junit.framework.*;

/**
 * 
 *
 */
public class ServerVersionTest extends TestCase {
    
    protected ServerVersion version_0_45 = new ServerVersion("0.45");
    protected ServerVersion version_0_0_45 = new ServerVersion("0.0.45");
    protected ServerVersion version_foo = new ServerVersion("foo");

    public ServerVersionTest(String name) 
    {
	super(name);
    }

    protected void setUp()
    {
    }

    public static Test suite()
    {
	return new TestSuite(ServerVersionTest.class);
    }

    public void testFallback()
    {
	ServerVersion v = new ServerVersion("foo");
	Assert.assertEquals(v.getNextVersion(), ServerVersion.OPENNAP044);
    }

    public void testRecognize()
    {
	ServerVersion v = new ServerVersion("opennap 0.45");
	Assert.assertEquals(v.getNextVersion(), ServerVersion.OPENNAP044);
	Assert.assertTrue(v.isCompatibleTo(ServerVersion.OPENNAP044));

	Assert.assertTrue(ServerVersion.OPENNAP044.isCompatibleTo
			  (ServerVersion.OPENNAP044));
    }

    public void testSlavanap()
    {
	ServerVersion v = new ServerVersion("SlavaNap 2.1.1");
	Assert.assertEquals(v.getNextVersion(), ServerVersion.SLAVANAP2);
    }

}
