/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.ID3FieldDataException;
import helliker.id3.ID3Tag;
import helliker.id3.NullsoftID3GenreTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class ID3v1Tag
implements ID3Tag {
    private final int TAG_SIZE;
    private final int TITLE_SIZE;
    private final int ARTIST_SIZE;
    private final int ALBUM_SIZE;
    private final int YEAR_SIZE;
    private final int COMMENT_SIZE;
    private final int TRACK_LOCATION;
    private final int GENRE_LOCATION;
    private final int MAX_GENRE;
    private final int MAX_TRACK;
    private final String TAG_START;
    private File mp3;
    private boolean headerExists;
    private String title;
    private String artist;
    private String album;
    private String year;
    private String comment;
    private int genre;
    private int track;

    private final boolean checkHeader(RandomAccessFile randomAccessFile) throws FileNotFoundException, IOException {
        boolean bl = false;
        if (randomAccessFile.length() > 128L) {
            randomAccessFile.seek(randomAccessFile.length() - 128L);
            byte[] byArray = new byte[3];
            if (randomAccessFile.read(byArray) != 3) {
                throw new IOException("Error encountered reading ID3 header");
            }
            String string = new String(byArray, 0, 3);
            bl = string.equals("TAG");
        }
        return bl;
    }

    private final void readTag(RandomAccessFile randomAccessFile) throws FileNotFoundException, IOException {
        randomAccessFile.seek(randomAccessFile.length() - 128L);
        byte[] byArray = new byte[128];
        randomAccessFile.read(byArray, 0, 128);
        String string = new String(byArray, 0, 128);
        int n = "TAG".length();
        this.title = this.chopSubstring(string, n, n += 30);
        this.artist = this.chopSubstring(string, n, n += 30);
        this.album = this.chopSubstring(string, n, n += 30);
        this.year = this.chopSubstring(string, n, n += 4);
        this.comment = this.chopSubstring(string, n, n += 28);
        this.track = byArray[126] & 0xFF;
        this.genre = byArray[127] & 0xFF;
    }

    private final String chopSubstring(String string, int n, int n2) {
        String string2 = string.substring(n, n2);
        int n3 = string2.indexOf(0);
        if (n3 != -1) {
            string2 = string2.substring(0, n3);
        }
        return string2;
    }

    public void writeTag() throws FileNotFoundException, IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.mp3, "rw");
            if (this.headerExists) {
                randomAccessFile.seek(randomAccessFile.length() - 128L);
            } else {
                randomAccessFile.seek(randomAccessFile.length());
            }
            randomAccessFile.write(this.getBytes());
        }
        finally {
            Object var3_2 = null;
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        this.headerExists = true;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[128];
        int n = 0;
        System.arraycopy("TAG".getBytes(), 0, byArray, n, "TAG".length());
        System.arraycopy(this.title.getBytes(), 0, byArray, n += "TAG".length(), this.title.length());
        System.arraycopy(this.artist.getBytes(), 0, byArray, n += 30, this.artist.length());
        System.arraycopy(this.album.getBytes(), 0, byArray, n += 30, this.album.length());
        System.arraycopy(this.year.getBytes(), 0, byArray, n += 30, this.year.length());
        System.arraycopy(this.comment.getBytes(), 0, byArray, n += 4, this.comment.length());
        byArray[126] = (byte)this.track;
        byArray[127] = (byte)this.genre;
        return byArray;
    }

    private final byte[] getFieldBytes(String string, int n) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = string.length();
        while (n2 < n) {
            stringBuffer.append('\u0000');
            ++n2;
        }
        return stringBuffer.toString().getBytes();
    }

    public void removeTag() throws FileNotFoundException, IOException {
        if (this.headerExists) {
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(this.mp3, "rw");
                Long l = new Long(randomAccessFile.length() - 128L);
                byte[] byArray = new byte[l.intValue()];
                if (randomAccessFile.read(byArray) != l.intValue()) {
                    throw new IOException("Error encountered while removing tag");
                }
                randomAccessFile.setLength(l);
                randomAccessFile.seek(0L);
                randomAccessFile.write(byArray);
            }
            finally {
                Object var3_4 = null;
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            this.headerExists = false;
        }
    }

    public String getGenreString() {
        return NullsoftID3GenreTable.getGenre(this.genre);
    }

    public boolean setGenreString(String string) {
        int n = NullsoftID3GenreTable.getGenre(string);
        boolean bl = false;
        if (n != -1) {
            this.genre = n;
            bl = true;
        }
        return bl;
    }

    public boolean tagExists() {
        return this.headerExists;
    }

    public String getTitle() {
        return this.title.trim();
    }

    public void setTitle(String string) {
        this.title = string.length() > 30 ? string.substring(0, 30) : string;
    }

    public String getArtist() {
        return this.artist.trim();
    }

    public void setArtist(String string) {
        this.artist = string.length() > 30 ? string.substring(0, 30) : string;
    }

    public String getAlbum() {
        return this.album.trim();
    }

    public void setAlbum(String string) {
        this.album = string.length() > 30 ? string.substring(0, 30) : string;
    }

    public String getYear() {
        return this.year.trim();
    }

    public void setYear(String string) {
        this.year = string.length() > 4 ? string.substring(0, 4) : string;
    }

    public String getComment() {
        return this.comment.trim();
    }

    public void setComment(String string) {
        this.comment = string.length() > 28 ? string.substring(0, 28) : string;
    }

    public int getTrack() {
        return this.track;
    }

    public void setTrack(int n) {
        if (n <= 255 && n >= 0) {
            this.track = n;
        }
    }

    public int getGenre() {
        return this.genre;
    }

    public void setGenre(int n) throws ID3FieldDataException {
        if (n > 255 || n < 0) {
            throw new ID3FieldDataException("Invalid genre value.  Must be between 0 and 255.");
        }
        this.genre = n;
    }

    public int getSize() {
        int n = 0;
        if (this.headerExists) {
            n = 128;
        }
        return n;
    }

    public String toString() {
        return "ID3v1.1\nTagSize:\t\t\t" + this.getSize() + " bytes\nTitle:\t\t\t\t" + this.getTitle() + "\nArtist:\t\t\t\t" + this.getArtist() + "\nAlbum:\t\t\t\t" + this.getAlbum() + "\nYear:\t\t\t\t" + this.getYear() + "\nComment:\t\t\t" + this.getComment() + "\nTrack:\t\t\t\t" + this.getTrack() + "\nGenre:\t\t\t\t" + this.getGenreString();
    }

    public void copyFrom(ID3Tag iD3Tag) {
    }

    public ID3v1Tag(File file) throws FileNotFoundException, IOException {
        RandomAccessFile randomAccessFile;
        block4: {
            this.TAG_SIZE = 128;
            this.TITLE_SIZE = 30;
            this.ARTIST_SIZE = 30;
            this.ALBUM_SIZE = 30;
            this.YEAR_SIZE = 4;
            this.COMMENT_SIZE = 28;
            this.TRACK_LOCATION = 126;
            this.GENRE_LOCATION = 127;
            this.MAX_GENRE = 255;
            this.MAX_TRACK = 255;
            this.TAG_START = "TAG";
            this.mp3 = null;
            this.headerExists = false;
            this.title = null;
            this.artist = null;
            this.album = null;
            this.year = null;
            this.comment = null;
            this.mp3 = file;
            this.title = new String();
            this.artist = new String();
            this.album = new String();
            this.year = new String();
            this.comment = new String();
            this.genre = -1;
            this.track = -1;
            randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
                this.headerExists = this.checkHeader(randomAccessFile);
                if (!this.headerExists) break block4;
                this.readTag(randomAccessFile);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
    }
}

