/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.ByteBuilder;
import de.vdheide.mp3.FrameDamagedException;
import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2DecompressionException;
import de.vdheide.mp3.ID3v2Exception;
import de.vdheide.mp3.ID3v2Frame;
import de.vdheide.mp3.ParseException;
import de.vdheide.mp3.Parser;
import de.vdheide.mp3.TagContent;
import de.vdheide.mp3.TagFormatException;

public abstract class TextFrame {
    protected ID3v2 id3v2;
    protected String type;
    protected ID3v2Frame frame;
    protected TagContent content;
    protected boolean use_compression;
    protected boolean encoding;

    public TextFrame(boolean bl, ID3v2 iD3v2, String string, TagContent tagContent, boolean bl2) throws TagFormatException {
        if (tagContent.getTextContent() == null) {
            throw new TagFormatException();
        }
        this.id3v2 = iD3v2;
        this.type = string;
        this.content = tagContent;
        this.use_compression = bl2;
        this.encoding = bl;
        ByteBuilder byteBuilder = new ByteBuilder(bl ? (byte)1 : -1, bl ? tagContent.getTextContent().length() * 2 + 1 : tagContent.getTextContent().length());
        byteBuilder.put(tagContent.getTextContent());
        byte[] byArray = byteBuilder.getBytes();
        try {
            this.frame = new ID3v2Frame(string, byArray, false, false, false, bl2 ? (byte)2 : 0, 0, 0);
        }
        catch (ID3v2DecompressionException iD3v2DecompressionException) {
            // empty catch block
        }
    }

    public void write() {
        try {
            this.id3v2.removeFrame(this.type);
        }
        catch (ID3v2Exception iD3v2Exception) {
            // empty catch block
        }
        this.id3v2.addFrame(this.frame);
    }

    public static TagContent read(boolean bl, ID3v2 iD3v2, String string) throws FrameDamagedException {
        TagContent tagContent = new TagContent();
        try {
            byte[] byArray = ((ID3v2Frame)iD3v2.getFrame(string).elementAt(0)).getContent();
            Parser parser = new Parser(byArray, bl);
            try {
                tagContent.setContent(parser.parseText());
            }
            catch (ParseException parseException) {
                throw new FrameDamagedException();
            }
        }
        catch (ID3v2Exception iD3v2Exception) {
            // empty catch block
        }
        return tagContent;
    }
}

