#include <xmms/plugin.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include "liveice.h"

#define MAX_SAMPLE 32768

short work1[32768],work2[32768];

/* average two stereo channels into a single mono channel */
void make_mono(short *stereo,short *mono,int num){
        unsigned int i;
        for(i=0;i<num;i++)
                mono[i]=(short)(((int)stereo[i*2]+(int)stereo[i*2+1])/2);

}

/* take a single mono channel and make it into 2 stereo channels */
void make_stereo(short *mono,short *stereo,int num){
        unsigned int i;
        for(i=0;i<num;i++)
                stereo[i*2]=stereo[i*2+1]=mono[i];

}


/* take an interleaved stereo file and split it into two seperate buffers */
void sep_stereo(short *stereo,short *left,short *right,int num){
        unsigned int i;
        for(i=0;i<num;i++){
                left[i]=stereo[i*2];
                right[i]=stereo[i*2+1];
        }  
}


/* take two buffers for left and right and interleave them into one channel */
void mix_stereo(short *left,short *right,short *stereo,int num){
        unsigned int i;
        for(i=0;i<num;i++){
                stereo[i*2]=left[i];
                stereo[i*2+1]=right[i];
        }  
}


/* integer sample rate converters */
void int_compress_samples(short *in, short *out,int num,int grain){
        unsigned int i,j;
        int smpl;

        for(i=0;i<num;i++){
                smpl=in[i*grain];
                for(j=1;j<grain;j++)
                        smpl+=in[i*grain+j];
                out[i]=(short)(smpl/grain);
        }

}


void int_stretch_samples(short *in,short *out,int num,int grain){
        unsigned int i,j;
        for(i=0;i<num;i++)
                for(j=0;j<grain;j++)
                        out[i*grain+j]=in[i];

}


/* totally ugly fractional sample rate conversions routine */
void compress_samples(short *in, short *out,unsigned int num1,unsigned int num2)
{
        float sample,pos,step=(float)(num1)/num2;
        int i,j;
        pos=step-1;
        sample=in[0];
        j=0;
        for(i=1;i<num1;i++){
                if(i>pos){
                        sample+= in[i] * (pos-i+1);
                        sample /= step;
                        if(sample>MAX_SAMPLE){
                                sample=MAX_SAMPLE;
                        } else if(sample<-MAX_SAMPLE){
                                sample=-MAX_SAMPLE;
                        }
                        out[j] = sample;
                        j++;
                        sample = in[i] * (i-pos);
                        pos=((j+1)*step)-1;
                } else {
                        sample += in[i];
                }
        }
        if(j!=num2){
                out[j]=sample/step;
        }
}


/* less ugly routine - still noisy */
void stretch_samples(short *in, short *out,unsigned int num1,unsigned int num2){
        float step=(float)(num1)/num2;
        int i;
        for(i=0;i<num2;i++){
                out[i]=in[(int)(i*step)];
        }
}


/* changes the length of a buffer of samples uses fast shortcuts where possible 
*/
void change_time(short *in,short *out,unsigned int num_in,unsigned int num_out){
        int i;

        if(num_in>num_out){
                /* compress samples */
                if(num_in==(num_out<<1)){
                        int_compress_samples(in,out,num_out,2);
                } else if ( num_in==(num_out<<2)) {
                        int_compress_samples(in,out,num_out,4);
                } else {
                        compress_samples(in,out,num_in,num_out);
                }
        } else if(num_in<num_out) {
                /* stretch samples */
                if((num_in<<1)==num_out){
                        int_stretch_samples(in,out,num_in,2);
                } else if ((num_in<<2)==num_out) {
                        int_stretch_samples(in,out,num_in,4);
                } else {
                        stretch_samples(in,out,num_in,num_out);
                }
        } else {
                for(i=0;i<num_out;i++)
                        out[i]=in[i];
        }
}


void convert_audio(short *in,short *out,int ch1,int ch2,int n1,int n2){
        int i;
        if((ch1==ch2) &&(n1==n2)){
                for(i=0;i<ch1*n1;i++)
                        out[i]=in[i];
                return;

        }
        if(ch2==1){
                /* output is mono */
                if(ch1==2){
                        /* input is stereo */
                        make_mono(in,work1,n1);       
                        change_time(work1,out,n1,n2);
                } else {
                        /* input is mono */
                        change_time(in,out,n1,n2);
                }
        } else {
                /* output is stereo */
                if(ch1==2){
                        /* input is stereo */
                        sep_stereo(  in,    work1, work2, n1    );
                        change_time( work1, in,    n1,    n2    );
                        change_time( work2, work1, n1,    n2    );
                        mix_stereo(  in,    work1, out,   n2    );
                } else {
                        /* input is mono */
                        change_time(in,work1,n1,n2);
                        make_stereo(work1,out,  n2);
                }
        }
}


int clip_audio(int *buffer,short *clipped,int num,float threshold){
        int i,clip;
        float clip_a,clip_b;

        clip  = MAX_SAMPLE * threshold;
        clip_a= (MAX_SAMPLE-clip)*(MAX_SAMPLE-clip);
        clip_b= MAX_SAMPLE - 2 * clip;

        for(i=0;i<num;i++) {
                if( (buffer[i]<clip) && (buffer[i]>-clip) )
                        clipped[i]=(short)(buffer[i]);
                else if (buffer[i]>0) 
                        clipped[i]= (MAX_SAMPLE-( clip_a / (clip_b+buffer[i]) ));
                else 
                        clipped[i]=-(MAX_SAMPLE-(clip_a / (clip_b-buffer[i]) ) );
        }

        return 0;
}

