#! /usr/local/bin/perl

# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is mozilla.org code.
#
# The Initial Developer of the Original Code is
# Netscape Communications Corporation.
# Portions created by the Initial Developer are Copyright (C) 1998
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either of the GNU General Public License Version 2 or later (the "GPL"),
# or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

$klist = @ARGV[0];
$gperfopts = @ARGV[1];
$clazz = @ARGV[2];
$prefix = @ARGV[3];
$props = @ARGV[4];
$ids = @ARGV[5];

# print "/* klist=$klist */\n";
# print "/* gperfopts=$gperfopts */\n";
# print "/* clazz=$clazz */\n";
# print "/* prefix=$prefix */\n";
# print "/* props=$props */\n";
# print "/* ids=$ids */\n";

open(NAMES_FILE, "<$props");
open(HASH, "|gperf -7 -T -t -l $gperfopts -NHashFunc -p -k$klist,\$ > gperf.out.$$");

# NOTE: the decl here needs to match the TAG_TABLE rules in genhash.inc!!!
print HASH 'struct StaticNameTable { char *name; int id; };
%%
';

open(ID_FILE, ">$ids");

# Load in tag names
$nextval = 0;
while (<NAMES_FILE>) {
  if (/(.*)/) {
    $prop = $1;
    $vals[$nextval] = $prop;
    $nextval = $nextval + 1;
  }
}

# Output tag id's to ID_FILE and hash info to HASH
print ID_FILE "/* Do not edit - generated by $0 */\n";
for ($i = 0; $i < $nextval; $i++) {
  $val = $vals[$i];
  $newval = $val;
  $newval =~ tr/a-z/A-Z/;
  $newval =~ s/-/_/g;
  print ID_FILE "#define $prefix$newval $i\n";
  print HASH $vals[$i] . ", $i\n";
}
print ID_FILE "#define $prefix" . "MAX $i\n";

close(NAMES_FILE);
close(HASH);
open(C, "<gperf.out.$$");
unlink("gperf.out.$$");
open(T, "<genhash.inc");

while (<T>) {
  if (/^\@begin/) {
    ($name, $start, $end) =
      m#\@begin[ 	]*([A-Za-z0-9_]+)[ 	]*/([^/]*)/[ 	]*/([^/]*)/#;
    $line = <C> until (eof(C) || $line =~ /$start/);
    if ($line =~ /$start/) {
      $template{$name} .= $line;
      do {
	$line = <C>;
	$template{$name} .= $line;
      } until ($line =~ /$end/ || eof(C));
    }
  } elsif (/^\@include/) {
    ($name) = /\@include[ 	]*(.*)$/;
    print $template{$name};
  } elsif (/^\@sub/) {
    ($name, $old, $new) =
      m#\@sub[ 	]*([A-Za-z0-9_]*)[ 	]/([^/]*)/([^/]*)/#;
    $template{$name} =~ s/$old/$new/g;
  } elsif (/^\@classfunc/) {
    print "PRInt32 $clazz\:\:LookupName(const char* str)\n";
  } elsif (/^\@classincl/) {
    print "#include \"$clazz.h\"\n";
  } elsif (/^@/) {
    ;
  } else {
    print $_;
  }
}

# Print out tag name table at the end
print "\nconst $clazz\:\:NameTableEntry $clazz\:\:kNameTable\[\] = {\n";
for ($i = 0; $i < $nextval; $i++) {
  $val = $vals[$i];
  $newval = $val;
  $newval =~ tr/a-z/A-Z/;
  print "  { \"$vals[$i]\", $i }, \n";
}
print "};\n";
