/*
   Copyright (C) 1997-2001 Id Software, Inc.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 */

#include "g_local.h"
#include "g_gametypes.h"

//==================
//G_Gametype_DUEL_ScoreboardMessage
//==================
char *G_Gametype_DUEL_ScoreboardMessage( void )
{
	char entry[MAX_TOKEN_CHARS];
	size_t len;
	int i, team;
	edict_t	*e;

	//fixed layout scheme id
	Q_snprintfz( scoreboardString, sizeof( scoreboardString ), "scb \"&duels " );
	len = strlen( scoreboardString );
	*entry = 0; // wsw : aiwa : fix unitialized value heisenbug

	//it's not sending the player in score order (yet)
	for( team = TEAM_ALPHA; team < TEAM_ALPHA + g_maxteams->integer; team++ )
	{
		for( i = 0; teamlist[team].playerIndices[i] != -1; i++ )
		{
			e = game.edicts + teamlist[team].playerIndices[i];

			//player tab entry
			*entry = 0;
			Q_snprintfz( entry, sizeof( entry ), "&p %i %i %i %i %i %i %i ",
			             e->s.team,
			             PLAYERNUM( e ),
			             match.scores[PLAYERNUM( e )].score,
			             match.scores[PLAYERNUM( e )].kills,
			             match.scores[PLAYERNUM( e )].deaths,
			             match.scores[PLAYERNUM( e )].suicides,
			             e->r.client->r.ping > 999 ? 999 : e->r.client->r.ping );

			if( SCOREBOARD_MSG_MAXSIZE - len > strlen( entry ) )
			{
				Q_strncatz( scoreboardString, entry, sizeof( scoreboardString ) );
				len = strlen( scoreboardString );
			}
		}
	}

	G_ScoreboardMessage_AddSpectators();

	// add player stats (all weapon weak/strong 0..99) to scoreboard message
	//	G_ScoreboardMessage_AddPlayerStats( ent );

	// add closing quote
	if( SCOREBOARD_MSG_MAXSIZE - len > strlen( entry ) )
	{
		Q_strncatz( scoreboardString, "\"", sizeof( scoreboardString ) );
		len = strlen( scoreboardString );
	}
	return scoreboardString;
}

//=================
//G_Gametype_DUEL_CheckRules
//=================
void G_Gametype_DUEL_CheckRules( void )
{
	if( match.state >= MATCH_STATE_POSTMATCH )
		return;

	if( game.gametype != GAMETYPE_DUEL )
		return;

	G_GameType_ClientHealthRule();
	//G_GameType_ClientArmorDecayRule();

	if( G_Match_GenericCountDownAnnounces() )
	{                                       // true once a second
	}
}
