/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "ui_local.h"

#ifdef UI_GLEXT_MENU

/*
=======================================================================

OPENGL EXTENSIONS MENU

=======================================================================
*/

static menuframework_s	s_glext_menu;

static void M_glextBackFunc( menucommon_t *menuitem ) {
	M_PopMenu();
}

static void M_UpdateGLExtensions( menucommon_t *menuitem ) {
	trap_Cvar_SetValue( "gl_extensions", menuitem->curvalue );
}
static void M_UpdateGLExtVArray( menucommon_t *menuitem ) {
	trap_Cvar_SetValue( "gl_ext_compiled_vertex_array", menuitem->curvalue );
}
static void M_UpdateGLExtMultitexture( menucommon_t *menuitem ) {
	trap_Cvar_SetValue( "gl_ext_multitexture", menuitem->curvalue );
}
static void M_UpdateGLExtEnvCombine( menucommon_t *menuitem ) {
	trap_Cvar_SetValue( "gl_ext_texture_env_combine", menuitem->curvalue );
}
static void M_UpdateGLExtEnvDot3( menucommon_t *menuitem ) {
	trap_Cvar_SetValue( "gl_ext_texture_env_dot3", menuitem->curvalue );
}
static void M_UpdateGLExtEnvCombine4( menucommon_t *menuitem ) {
	trap_Cvar_SetValue( "gl_ext_NV_texture_env_combine4", menuitem->curvalue );
}
static void M_UpdateGLExtCompressTex( menucommon_t *menuitem ) {
	trap_Cvar_SetValue( "gl_ext_compressed_textures", menuitem->curvalue );
}
static void M_UpdateGLExtCubemap( menucommon_t *menuitem ) {
	trap_Cvar_SetValue( "gl_ext_texture_cube_map", menuitem->curvalue );
}
static void M_UpdateGLExtAnisotropic( menucommon_t *menuitem ) {
	trap_Cvar_SetValue( "gl_ext_texture_filter_anisotropic", menuitem->curvalue );
}
/*
** GLExt_MenuInit
*/
static void GLExt_MenuInit( void )
{
	menucommon_t *menuitem;
	static char *sbar = "Note: values below 2 do not make any effect";
	int yoffset = 0;

	s_glext_menu.nitems = 0;

	// title
	menuitem = UI_InitMenuItem( "m_glext_title1", "OPENGL EXTENSION SETTINGS", 0, yoffset, MTYPE_SEPARATOR, ALIGN_CENTER_TOP, uis.fontSystemBig, NULL );
	Menu_AddItem( &s_glext_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_glext_extensions", "OpenGL Extensions", 0, yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, M_UpdateGLExtensions );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "gl_extensions" ) );
	menuitem->statusbar = "set this to 'off' to disable all extensions";
	Menu_AddItem( &s_glext_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_glext_varray", "Compiled vertex array", 0, yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, M_UpdateGLExtVArray );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "gl_ext_compiled_vertex_array" ) );
	Menu_AddItem( &s_glext_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_glext_mtext", "Multitexturing", 0, yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, M_UpdateGLExtMultitexture );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "gl_ext_multitexture" ) );
	Menu_AddItem( &s_glext_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_glext_envcombine", "Env Combine", 0, yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, M_UpdateGLExtEnvCombine );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "gl_ext_texture_env_combine" ) );
	Menu_AddItem( &s_glext_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_glext_envdot3", "Env Dot3", 0, yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, M_UpdateGLExtEnvDot3 );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "gl_ext_texture_env_dot3" ) );
	Menu_AddItem( &s_glext_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_glext_envcomb4", "NVidia Env Combine4", 0, yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, M_UpdateGLExtEnvCombine4 );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "gl_ext_NV_texture_env_combine4" ) );
	Menu_AddItem( &s_glext_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_glext_textcompress", "Texture compression", 0, yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, M_UpdateGLExtCompressTex );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "gl_ext_compressed_textures" ) );
	Menu_AddItem( &s_glext_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_glext_cubemaps", "Cubemaps", 0, yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, M_UpdateGLExtCubemap );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "gl_ext_texture_cube_map" ) );
	Menu_AddItem( &s_glext_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_glext_anisotropic", "Texture anisotropic filter", 0, yoffset, MTYPE_SLIDER, ALIGN_RIGHT_TOP, uis.fontSystemSmall, M_UpdateGLExtAnisotropic );
	UI_SetupSlider( menuitem, 12, trap_Cvar_VariableValue( "gl_ext_texture_filter_anisotropic" ), 0, trap_Cvar_VariableValue( "gl_ext_max_texture_filter_anisotropic" ) );
	menuitem->statusbar = sbar;
	Menu_AddItem( &s_glext_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_glext_back", "back", 0, yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, M_glextBackFunc );
	Menu_AddItem( &s_glext_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	Menu_Center( &s_glext_menu );
	Menu_Init ( &s_glext_menu );
}

/*
================
GLExt_MenuDraw
================
*/
static void GLExt_MenuDraw( void )
{
	/*
	** move cursor to a reasonable starting position
	*/
	Menu_AdjustCursor( &s_glext_menu, 1 );

	/*
	** draw the menu
	*/
	Menu_Draw( &s_glext_menu );
}

/*
================
GLExt_MenuKey
================
*/
static const char *GLExt_MenuKey( int key )
{
	return Default_MenuKey( &s_glext_menu, key );
}

static const char *GLExt_MenuCharEvent( int key )
{
	return Default_MenuCharEvent( &s_glext_menu, key );
}

void M_Menu_GLExt_f( void )
{
	GLExt_MenuInit();
	M_PushMenu( &s_glext_menu, GLExt_MenuDraw, GLExt_MenuKey, GLExt_MenuCharEvent );
}
#endif
