/*
Copyright (C) 2002-2003 Victor Luchits

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "cg_local.h"

//==================
//CG_SC_Print
//==================
static void CG_SC_Print( void )
{
	CG_Printf( "%s", trap_Cmd_Argv(1) );
}

//==================
//CG_SC_Print
//==================
static void CG_SC_ChatPrint( void )
{
	CG_Printf( "%s", trap_Cmd_Argv(1) );
	trap_S_StartGlobalSound( CG_MediaSfx(cgs.media.sfxChat), CHAN_AUTO, 1.0f );
}

//==================
//CG_SC_CenterPrint
//==================
static void CG_SC_CenterPrint( void ) {
	CG_CenterPrint( trap_Cmd_Argv(1) );
}

//================
//CG_ConfigString
//================
void CG_ConfigString( int i, char *s )
{
	char	olds[MAX_QPATH];
	int		len;

	// wsw : jal : warn if configstring overflow
	len = strlen( s );
	if( len >= MAX_QPATH )
		CG_Printf( "%sWARNING:%s Configstring %i overflowed\n", S_COLOR_YELLOW, S_COLOR_WHITE, i );

	if ( i < 0 || i >= MAX_CONFIGSTRINGS ) {
		CG_Error( "configstring > MAX_CONFIGSTRINGS" );
	}

	Q_strncpyz( olds, cgs.configStrings[i], sizeof(olds) );
	Q_strncpyz( cgs.configStrings[i], s, sizeof(cgs.configStrings[i]) );

	// do something apropriate 
	if( i == CS_MAPNAME ) {
		CG_RegisterLevelShot();
	} 
	else if( i == CS_SERVERSETTINGS ) {
		CG_UpdateServerSettings();
	}
	else if( i >= CS_MODELS && i < CS_MODELS+MAX_MODELS ) {
		if( cgs.configStrings[i][0] == '$') {	// indexed pmodel
			cgs.pModelsIndex[i-CS_MODELS] = CG_RegisterPlayerModel( cgs.configStrings[i]+1 );
		} else {
			cgs.modelDraw[i-CS_MODELS] = CG_RegisterModel( cgs.configStrings[i] );	// skelmod
		}
	} 
	else if( i >= CS_SOUNDS && i < CS_SOUNDS+MAX_SOUNDS ) {
		if( cgs.configStrings[i][0] != '*' ) {
			cgs.soundPrecache[i-CS_SOUNDS] = trap_S_RegisterSound( cgs.configStrings[i] );
		}
	} 
	else if( i >= CS_IMAGES && i < CS_IMAGES+MAX_IMAGES ) {
		cgs.imagePrecache[i-CS_IMAGES] = trap_R_RegisterPic( cgs.configStrings[i] );
	} 
	else if( i >= CS_SKINFILES && i < CS_SKINFILES+MAX_SKINFILES ) {
		cgs.skinPrecache[i-CS_SKINFILES] = trap_R_RegisterSkinFile( cgs.configStrings[i] );
	} 
	else if( i >= CS_LIGHTS && i < CS_LIGHTS+MAX_LIGHTSTYLES ) {
		CG_SetLightStyle( i - CS_LIGHTS );
	} 
	else if( i >= CS_ITEMS && i < CS_ITEMS+MAX_ITEMS ) {
		CG_ValidateItemDef( i - CS_ITEMS, cgs.configStrings[i] );
	} 
	else if( i >= CS_PLAYERINFOS && i < CS_PLAYERINFOS+MAX_CLIENTS ) {
		CG_LoadClientInfo( &cgs.clientInfo[i-CS_PLAYERINFOS], cgs.configStrings[i], i-CS_PLAYERINFOS );
	}
	else if( i >= CS_GAMECOMMANDS && i < CS_GAMECOMMANDS+MAX_GAMECOMMANDS ) {
		if( !cgs.demoPlaying )
			trap_Cmd_AddCommand( cgs.configStrings[i], NULL );
	}
}

//================
//CG_SC_Inventory
//================
static void CG_SC_Inventory( void )
{
	int		i, rep;
	char	inv[MAX_TOKEN_CHARS], *s;

	Q_strncpyz( inv, trap_Cmd_Argv( 1 ), sizeof( inv ) );

	cg.inventory[0] = 0;	// item 0 is never used
	for( i = 1, s = inv; (i < MAX_ITEMS) && s && *s; i++ ) {
		cg.inventory[i] = atoi( COM_Parse(&s) );
		if( cg.inventory[i] )
			continue;

		for( rep = atoi( COM_Parse(&s) ); (rep > 0) && (i < MAX_ITEMS); rep-- )
			cg.inventory[i++] = 0;
		i--;
	}
}


//================
//CG_SC_Scoreboard	// wsw : jal : scoreboard templates
//================
static void CG_SC_Scoreboard( void )
{
	SCR_UpdateScoreboardMessage( trap_Cmd_Argv(1) );
}

//================
//CG_SC_AutoRecord
//================
static void CG_SC_AutoRecord( void )
{
	static qboolean autorecording = qfalse;
	time_t long_time;
	struct tm *newtime;
	char name[MAX_STRING_CHARS];
	char mapname[MAX_CONFIGSTRING_CHARS];
	char *cleanplayername, *cleanplayername2, *action;
	qboolean spectator;

	// filter out autorecord commands when playing a demo
	if( cgs.demoPlaying )
		return;

	if( cg.frame.playerState.pmove.pm_type == PM_SPECTATOR || cg.frame.playerState.pmove.pm_type == PM_CHASECAM )
		spectator = qtrue;
	else
		spectator = qfalse;

	// get date from system
	time( &long_time );
	newtime = localtime( &long_time );

	// remove color tokens from player names (doh)
	cleanplayername = COM_RemoveColorTokens( cgs.clientInfo[cg.chasedNum].name );

	// remove junk chars from player names for files
	cleanplayername2 = COM_RemoveJunkChars( cleanplayername );

	// lowercase mapname
	Q_strncpyz( mapname, cgs.configStrings[CS_MAPNAME], sizeof(mapname) );
	Q_strlwr( mapname );

	// make file name
	// duel_year-month-day_hour-min_map_player
	Q_snprintfz( name, sizeof(name), "%s_%04d-%02d-%02d_%02d-%02d_%s_%s",
				GS_Gametype_ShortName( cg.frame.playerState.stats[STAT_GAMETYPE] ),
				newtime->tm_year + 1900, newtime->tm_mon+1, newtime->tm_mday, 
				newtime->tm_hour, newtime->tm_min,
				mapname,
				cleanplayername2
				);

	action = trap_Cmd_Argv(1);
	if( !Q_stricmp(action, "start") )
	{
		if( cg_autoaction_demo->integer && (!spectator || cg_autoaction_spectator->integer) )
		{
			trap_Cmd_ExecuteText( EXEC_NOW, "stop silent" );
			trap_Cmd_ExecuteText( EXEC_NOW, va("record autorecord/%s/%s silent",
				GS_Gametype_ShortName(cg.frame.playerState.stats[STAT_GAMETYPE]), name) );
			autorecording = qtrue;
		}
	}
	else if( !Q_stricmp(action, "stop") )
	{
		if( autorecording )
		{
			trap_Cmd_ExecuteText( EXEC_NOW, "stop silent" );
			autorecording = qfalse;
		}

		if( cg_autoaction_screenshot->integer && (!spectator || cg_autoaction_spectator->integer) )
		{
			trap_Cmd_ExecuteText( EXEC_NOW, va("screenshot autorecord/%s/%s silent",
				GS_Gametype_ShortName(cg.frame.playerState.stats[STAT_GAMETYPE]), name) );
		}
	}
	else if( !Q_stricmp(action, "cancel") )
	{
		if( autorecording )
		{
			trap_Cmd_ExecuteText( EXEC_NOW, "stop cancel silent" );
			autorecording = qfalse;
		}
	}
	else if( !Q_stricmp(action, "stats") )
	{
		CG_Printf( trap_Cmd_Argv(2) );

		if( cg_autoaction_stats->integer && (!spectator || cg_autoaction_spectator->integer) )
		{
			int file;
			if( trap_FS_FOpenFile(
					va("stats/%s/%s.txt", GS_Gametype_ShortName(cg.frame.playerState.stats[STAT_GAMETYPE]), name),
					&file, FS_APPEND) == -1 )
			{
				CG_Printf( "Couldn't write autorecorded stats, error opening file %s\n",
					va("stats/%s/%s.txt", GS_Gametype_ShortName(cg.frame.playerState.stats[STAT_GAMETYPE]), name) );
				return;
			}
			trap_FS_Write( trap_Cmd_Argv(2), strlen(trap_Cmd_Argv(2)), file );
			trap_FS_FCloseFile( file );
		}
	}
	else if( developer->integer )
	{
		CG_Printf( "CG_SC_AutoRecord: Unknown argument: %s\n", action );
	}
}

//=======================================================

//==================
//CG_SC_ChannelAdd
//==================
static void CG_SC_ChannelAdd( void )
{
	int		i, id;
	char	menuparms[MAX_STRING_CHARS];
	char	*name, *address;

	for( i = 1; i+2 < trap_Cmd_Argc(); i += 3 ) {
		id = atoi(trap_Cmd_Argv(i));
		name = trap_Cmd_Argv(i+1);
		address = trap_Cmd_Argv(i+2);
		if( id <= 0 || !name[0] || !address[0] )
			continue;

		Q_snprintfz( menuparms, sizeof(menuparms), "menu_tv_channel_add %i \"%s\" \"%s\"", id, name, address );
		trap_Cmd_ExecuteText( EXEC_APPEND, menuparms );
	}
}

//==================
//CG_SC_ChannelRemove
//==================
static void CG_SC_ChannelRemove( void )
{
	int		i, id;

	for( i = 1; i < trap_Cmd_Argc(); i++ ) {
		id = atoi(trap_Cmd_Argv(i));
		if( id <= 0 )
			continue;
		trap_Cmd_ExecuteText( EXEC_APPEND, va("menu_tv_channel_remove %i", id) );
	}
}

//=======================================================

static void CG_SC_MatchMessage( void ) {
	Q_strncpyz( cg.matchmessage, trap_Cmd_Argv(1), sizeof(cg.matchmessage) );
}

static void CG_CS_UpdateTeamInfo( void ) {
	Q_strncpyz( cg.teaminfo, trap_Cmd_Argv(1), sizeof(cg.teaminfo) );
}

//=======================================================

static void CG_SC_Layout( void ) {
	CG_LoadLayout( trap_Cmd_Argv(1) );
}

//=======================================================

static qboolean demo_requested = qfalse;

void CG_Cmd_DemoGet_f( void )
{
	if( demo_requested ) {
		CG_Printf( "Already requesting a demo\n" );
		return;
	}

	if( trap_Cmd_Argc() != 2 || (atoi(trap_Cmd_Argv(1)) <= 0 && trap_Cmd_Argv(1)[0] != '.') ) {
		CG_Printf( "Usage: demoget <number>\n" );
		CG_Printf( "Donwloads a demo from the server\n" );
		CG_Printf( "Use the demolist command to see list of demos on the server\n" );
		return;
	}

	trap_Cmd_ExecuteText( EXEC_NOW, va("svdemoget %s", trap_Cmd_Argv(1)) );

	demo_requested = qtrue;
}

static void CG_SC_DemoGet( void )
{
	if( cgs.demoPlaying ) {
		// ignore download commands coming from demo files
		return;
	}

	if( !demo_requested ) {
		CG_Printf( "Warning: demoget when not requested, ignored\n" );
		return;
	}

	demo_requested = qfalse;

	if( trap_Cmd_Argc() < 2 ) {
		CG_Printf( "No such demo found\n" );
		return;
	}

	if( !COM_ValidateRelativeFilename(trap_Cmd_Argv(1)) ) {
		CG_Printf( "Warning: demoget: Invalid filename, ignored\n" );
		return;
	}

	trap_DownloadRequest( va("demos/server/%s.wd%i", trap_Cmd_Argv(1), cgs.gameProtocol ), qfalse );
}

//=======================================================

//==================
//CG_SC_MenuCA
//==================
static void CG_SC_MenuCA( void )
{
	trap_Cmd_ExecuteText( EXEC_APPEND, "menu_ca" );
}

//=======================================================

typedef struct
{
	char	*name;
	void	(*func) (void);
} svcmd_t;

svcmd_t cg_svcmds[] =
{
	{ "pr", CG_SC_Print },
	{ "ch", CG_SC_ChatPrint },
	{ "cp", CG_SC_CenterPrint },
	{ "obry", CG_SC_Obituary },
	{ "inv", CG_SC_Inventory },
	{ "scb", CG_SC_Scoreboard }, // wsw : jal : scoreboard templates
	{ "autr", CG_SC_AutoRecord }, // wsw : jal : autorecord command
	{ "mm", CG_SC_MatchMessage },
	{ "layout", CG_SC_Layout },
	{ "ti", CG_CS_UpdateTeamInfo },
	{ "demoget", CG_SC_DemoGet },
	{ "aw", CG_SC_Award },
	{ "cha", CG_SC_ChannelAdd },
	{ "chr", CG_SC_ChannelRemove },
	{ "mnca", CG_SC_MenuCA },

	{ NULL }
};

/*
==================
CG_GameCommand
==================
*/
void CG_GameCommand( char *command )
{
	char *s;
	svcmd_t *cmd;

	trap_Cmd_TokenizeString( command );

	s = trap_Cmd_Argv( 0 );
	for( cmd = cg_svcmds; cmd->name; cmd++ ) {
		if( !strcmp (s, cmd->name) ) {
			cmd->func();
			return;
		}
	}

	CG_Printf( "Unknown game command: %s\n", s );
}
