/*
 * Iconbar - VRwave icon toolbar
 *
 * created: mpichler, 19970916
 *
 * changed: mpichler, 19970925
 *
 * $Id: Iconbar.java,v 1.6 1997/09/25 16:35:09 mpichler Exp $
 */


package iicm.vrml.vrwave;

import iicm.widgets.FramedArea;
import iicm.widgets.ImageButton;
import iicm.widgets.ImageButtonGroup;
import iicm.widgets.ImageCanvas;

import java.awt.*;
import java.net.*;


/**
 * Iconbar - VRwave icon toolbar
 */

public class Iconbar extends Panel
{
  Scene scene_;
  Image icons_;
  Image logo_;
  ImageButton[] navbutton_;
  ImageButtonGroup navbuttons_;
  ImageButton behavior_, interaction_;

  public Iconbar (Scene scene)
  {
    scene_ = scene;
    setLayout (new BorderLayout ());

    if (VRwave.iconimages)
      loadIcons ();  // into icons_ and logo_

    String[][] mstrings = Translator.strings;  // menu labels
    int lang = Translator.language_;
    int hgap = 2;
    int vgap = 1;

    // do not change the order of the individual icons in the composed image
    Panel navbar = new Panel ();
    navbar.setLayout (new FlowLayout (FlowLayout.LEFT, hgap, vgap));
    navbutton_ = new ImageButton [Scene.NUMNAVMODES];
    navbuttons_ = new ImageButtonGroup ();
    addnavbutton (navbar, Scene.FLIP, MenuDef.M_Flip, 0);
    addnavbutton (navbar, Scene.WALK, MenuDef.M_Walk, 1);
    addnavbutton (navbar, Scene.FLYTO, MenuDef.M_FlyTo, 2);
    addnavbutton (navbar, Scene.HEADSUP, MenuDef.M_HeadsUp, 3);
    add ("West", navbar);

    Panel others = new Panel ();
    others.setLayout (new FlowLayout (FlowLayout.RIGHT, hgap, vgap));
    others.add (behavior_ = new ImageButton (
      mstrings [MenuDef.M_Behaviour][lang], ImageButton.subimage (icons_, 4 * IWIDTH, 0, IWIDTH, IHEIGHT, this),
      IWIDTH, IHEIGHT, scene.getBehavior (), null));
    others.add (interaction_ = new ImageButton (
      mstrings [MenuDef.M_Interaction][lang], ImageButton.subimage (icons_, 5 * IWIDTH, 0, IWIDTH, IHEIGHT, this),
      IWIDTH, IHEIGHT, scene.getInteraction (), null));
    add ("Center", others);

    if (logo_ != null)
    {
      Panel logoarea = new Panel ();
      logoarea.setLayout (new FlowLayout (FlowLayout.LEFT, hgap, vgap));
      logoarea.add (new ImageCanvas (logo_));
      add ("East", logoarea);
    }

    scene.setIconbuttons (navbutton_, behavior_, interaction_);
  } // constructor

  /**
   * laod composed icon image into icons_ and logo_, wait until it is ready
   */

  private void loadIcons ()
  {
    String iconlocation, logolocation;

    String home = VRwave.home_;
    if (home == null)
    {
      System.err.println ("VRwave: cannot locate icons.gif. Call with -home $VRWAVE_HOME\n");
      return;
    }

    Toolkit toolkit = Toolkit.getDefaultToolkit ();
    iconlocation = home + "/icons.gif";
    logolocation = home + "/logo.gif";
    if (VRwave.verbose)
      System.err.println ("reading icon images: " + iconlocation);

    if (home.indexOf (':') >= 0)  // URL
    {
      try
      {
        icons_ = toolkit.getImage (new URL (iconlocation));
        logo_ = toolkit.getImage (new URL (logolocation));
      }
      catch (MalformedURLException e)
      {
        System.out.println ("invalid icon or logo URL <" + iconlocation + ">");
      }
    }
    else  // file
    {
      icons_ = toolkit.getImage (iconlocation);
      logo_ = toolkit.getImage (logolocation);
    }

    // wait for the image (to show labels on error)
    int iconID = 0;
    int logoID = 1;
    MediaTracker tracker = new MediaTracker (this);
    tracker.addImage (icons_, iconID);
    tracker.addImage (logo_, logoID);
    try
    {
      tracker.waitForID (iconID);
      tracker.waitForID (logoID);
    }
    catch (InterruptedException e)  { }

    if (tracker.isErrorID (iconID))
    {
      System.err.println ("VRwave: could not load icons at " + iconlocation);
      icons_ = null;
    }
    if (tracker.isErrorID (logoID))
    {
      System.err.println ("VRwave: could not load logo at " + logolocation);
      logo_ = null;
    }

    if (VRwave.verbose && icons_ != null)
      System.err.println ("total icon size: " + icons_.getWidth (this) + " x " + icons_.getHeight (this));

  } // loadIcons

  // icon width and height
  static final int IWIDTH = 30;
  static final int IHEIGHT = 23;

  private void addnavbutton (Panel group, int navmode, int m_label, int iconno)
  {
    // happened that label was shown when not waiting for cropping to complete
    Image icon = ImageButton.subimage (icons_, iconno * IWIDTH, 0, IWIDTH, IHEIGHT, this);

    group.add (navbutton_ [navmode] = new ImageButton (
      Translator.strings [m_label][Translator.language_], icon, IWIDTH, IHEIGHT, scene_.movemode_ == navmode, navbuttons_
    ));
  }

  /**
   * mouseDown. action
   */

  public boolean mouseDown (Event e, int x, int y)
  {
    Object target = e.target;

    for (int i = 0;  i < Scene.NUMNAVMODES;  i++)
      if (target == navbutton_ [i])
      {
        scene_.setNavigationMode (i, Scene.UPDATE_MENU);
        scene_.redraw ();  // new UI
        return true;  // handled
      }

    if (target == behavior_)
    {
      scene_.toggleBehavior (Scene.UPDATE_MENU);
      if (scene_.behavior ())
        scene_.redraw ();
    }
    else if (target == interaction_)
      scene_.toggleInteraction (Scene.UPDATE_MENU);

    return true;  // handled
  }

  public Insets insets ()
  { 
    // apparently Panel only allowed to draw into inset area
    return new Insets (2, 2, 2, 2);  // TLBR
  }

  /**
   * paint. add outset frame
   */

  public void paint (Graphics gc)
  {
    try
    { super.paint (gc);  // seems to have disappeared in JDK 1.1
    }
    catch (Throwable t)  { }

    Dimension size = size ();
    // gc.setColor (getBackground ());  // a bit too bright
    gc.setColor (new Color (0xA2A2A2));
    gc.draw3DRect (0, 0, size.width-1, size.height-1, true);
    gc.draw3DRect (1, 1, size.width-3, size.height-3, true);
  }

} // Iconbar
