#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "global.h"

int warning_len = 0;
char vqr_error[MAX_GLOBAL_LENGTH],
     vqr_warning[MAX_GLOBAL_LENGTH];

struct par_t {
  char id[3],
       *val;

  struct par_t *next;
};

struct par_t *parlist = NULL, *pt = NULL;

void global_init(void)
{
  memset((char *)vqr_error, 0, MAX_GLOBAL_LENGTH);
  memset((char *)vqr_warning, 0, MAX_GLOBAL_LENGTH);

  warning_len = 0;

  parlist = (struct par_t *)malloc(sizeof(struct par_t));
  parlist->next = NULL;

  pt = parlist;
}

/*
   Defines a global error

   err         - Error
   init        - Error occured during initialization process
   recoverable - Error is recoverable

   vol@inter7.com
*/
void global_error(char *err, char init, char recoverable)
{
  memset((char *)vqr_error, 0, MAX_GLOBAL_LENGTH);
  memcpy((char *)vqr_error, (char *)err, MAX_GLOBAL_LENGTH);

  if (init)
     t_open(T_INIT_ERROR);  
  
  if (!recoverable)
     t_open(T_ERROR);
}

void global_warning(char *warn)
{
  int len = 0;

  len = strlen(warn);
 
  if ((len + 1) >= (MAX_GLOBAL_LENGTH - warning_len))
     return;  

  memcpy((char *)(vqr_warning + warning_len), (char *)warn, (MAX_GLOBAL_LENGTH - warning_len));

  warning_len += len;

  *(vqr_warning + warning_len) = '$';

  warning_len++;

  *(vqr_warning + warning_len) = '\0';
}

void global_par(char *id, char *val)
{
  struct par_t *p = NULL;

  if ((id == NULL) || (val == NULL))
     global_error("NULL parameter", 0, 0);

  p = (struct par_t *)malloc(sizeof(struct par_t));
  if (p == NULL)
     global_error("Out of memory", 0, 0);

  memset((char *)p->id, 0, 3);
  memcpy((char *)p->id, (char *)id, 2);

  p->next = NULL;

  p->val = (char *)malloc(strlen(val) + 1);
  if (p->val == NULL)
     global_error("Out of memory", 0, 0);
  
  memset((char *)p->val, 0, strlen(val) + 1);
  memcpy((char *)p->val, (char *)val, strlen(val));

  pt->next = p;
  pt = p;  
}

char *f_global_par(char *id)
{
  struct par_t *p = NULL;
  
  for (p = parlist; p->next; p = p->next) {
      if (!(strcmp(p->next->id, id)))
         return p->next->val;      
  }

  return NULL;
}

/*
   Flush all warnings
*/
void global_f_warning(void)
{
  char *h = NULL, *t = NULL;

  if (!(*vqr_warning))
     return;

  for (h = t = vqr_warning;;) {
      if ((*h == '$') || (!(*h))) {
         if (*h)
            *h++ = '\0';
         else
            h = NULL;
    
         printf("%s<BR>", t);

         if (h == NULL)
            break;

         t = h;
      }
      else
         h++;
  }
}
