/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.configuration;

import java.io.IOException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.configuration.ConfigurationParser;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ConfigurationReader {
    private static boolean errorDump = false;
    private InputSource filename;

    public ConfigurationReader(InputSource inputSource) {
        this.filename = inputSource;
    }

    static XMLReader createParser() {
        block10: {
            String string = System.getProperty("org.xml.sax.parser");
            if (string == null) {
                string = "org.apache.xerces.parsers.SAXParser";
            }
            if (errorDump) {
                MessageHandler.logln("configuration reader using SAX parser " + string);
            }
            try {
                return (XMLReader)Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                MessageHandler.errorln("Could not find " + string);
                if (errorDump) {
                    classNotFoundException.printStackTrace();
                }
            }
            catch (InstantiationException instantiationException) {
                MessageHandler.errorln("Could not instantiate " + string);
                if (errorDump) {
                    instantiationException.printStackTrace();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                MessageHandler.errorln("Could not access " + string);
                if (errorDump) {
                    illegalAccessException.printStackTrace();
                }
            }
            catch (ClassCastException classCastException) {
                MessageHandler.errorln(String.valueOf(string) + " is not a SAX driver");
                if (!errorDump) break block10;
                classCastException.printStackTrace();
            }
        }
        return null;
    }

    public void dumpError(Exception exception) {
        if (errorDump) {
            if (exception instanceof SAXException) {
                exception.printStackTrace();
                if (((SAXException)exception).getException() != null) {
                    ((SAXException)exception).getException().printStackTrace();
                }
            } else {
                exception.printStackTrace();
            }
        }
    }

    public void setDumpError(boolean bl) {
        errorDump = bl;
    }

    public void start() throws FOPException {
        XMLReader xMLReader = ConfigurationReader.createParser();
        if (xMLReader == null) {
            MessageHandler.errorln("ERROR: Unable to create SAX parser");
            System.exit(1);
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXException sAXException) {
            MessageHandler.errorln("You need a parser which supports SAX version 2");
            if (errorDump) {
                sAXException.printStackTrace();
            }
            System.exit(1);
        }
        ConfigurationParser configurationParser = new ConfigurationParser();
        xMLReader.setContentHandler(configurationParser);
        try {
            xMLReader.parse(this.filename);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof FOPException) {
                this.dumpError(sAXException.getException());
                throw (FOPException)sAXException.getException();
            }
            this.dumpError(sAXException);
            throw new FOPException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            this.dumpError(iOException);
            throw new FOPException(iOException.getMessage());
        }
    }
}

