/*
 * Decompiled with CFR 0.152.
 */
package com.werken.xpath.impl;

import com.werken.xpath.ContextSupport;
import com.werken.xpath.impl.UnAbbrStep;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class NameTestStep
extends UnAbbrStep {
    private String _namespacePrefix = null;
    private String _localName = null;

    public NameTestStep(String axis, String namespacePrefix, String localName) {
        super(axis);
        this._namespacePrefix = namespacePrefix;
        this._localName = localName;
    }

    public List applyToAttribute(Object node, ContextSupport support) {
        ArrayList<Attribute> results = new ArrayList<Attribute>();
        Attribute attr = null;
        Namespace ns = null;
        String nsURI = null;
        if (node instanceof Element) {
            if ("*".equals(this._localName)) {
                results.addAll(((Element)node).getAttributes());
            } else {
                attr = null;
                if ("".equals(this._namespacePrefix)) {
                    attr = ((Element)node).getAttribute(this._localName);
                } else {
                    nsURI = support.translateNamespacePrefix(this._namespacePrefix);
                    ns = Namespace.getNamespace((String)nsURI);
                    attr = ((Element)node).getAttribute(this._localName, ns);
                }
                if (attr != null) {
                    results.add(attr);
                }
            }
        }
        return results;
    }

    public List applyToChild(Object node, ContextSupport support) {
        ArrayList<Element> results = new ArrayList<Element>();
        String nsURI = null;
        Namespace ns = null;
        if (this._namespacePrefix != null) {
            nsURI = support.translateNamespacePrefix(this._namespacePrefix);
        }
        if (node instanceof Document) {
            Element child = ((Document)node).getRootElement();
            if (child.getName().equals(this._localName)) {
                if (nsURI == null) {
                    results.add(child);
                } else if (nsURI.equals(child.getNamespaceURI())) {
                    results.add(child);
                }
            }
        } else if (node instanceof Element) {
            if ("*".equals(this._localName)) {
                List children = ((Element)node).getChildren();
                if (nsURI == null) {
                    results.addAll(children);
                } else {
                    Iterator childIter = children.iterator();
                    Element nodeChild = null;
                    while (childIter.hasNext()) {
                        nodeChild = (Element)childIter.next();
                        if (!nsURI.equals(nodeChild.getNamespaceURI())) continue;
                        results.add(nodeChild);
                    }
                }
            } else {
                ns = Namespace.getNamespace((String)nsURI);
                results.addAll(((Element)node).getChildren(this._localName, ns));
            }
        }
        return results;
    }

    public List applyToSelf(Object node, ContextSupport support) {
        ArrayList<Object> results = new ArrayList<Object>();
        if (node instanceof Element) {
            if (("*".equals(this._localName) || ((Element)node).getName().equals(this._localName)) && ((Element)node).getNamespaceURI().equals(support.translateNamespacePrefix(this._namespacePrefix))) {
                results.add(node);
            }
        } else if (node instanceof Attribute && ((Attribute)node).getName().equals(this._localName) && ((Attribute)node).getNamespaceURI().equals(support.translateNamespacePrefix(this._namespacePrefix))) {
            results.add(node);
        }
        return results;
    }

    public String toString() {
        return "[NameTestStep [" + this._namespacePrefix + ":" + this._localName + "]]";
    }
}

