#!/bin/bash
#
#  userful-debug-command.sh
#
############################


############
# usage()
############
function usage()
{
	echo ""
	echo "Usage: userful debug [OPTION]"
	echo ""
	echo -e "\tOPTIONS:"
	echo -e "\t\t-h"
	echo -e "\t\t-help\t- Print this help message"
	echo -e "\t\t-submit\t- Submit debug information"
	echo ""
	exit 1
}

##########################
# createDetails()
# Get Reporter's Information
##########################
function createDetails()
{
    # Get EMAIL Address
    INPUT=
    while [ "$INPUT" != "y" -a "$INPUT" != "Y" ]; 
    do
        INPUT=
        EMAIL=
        echo ""
        echo -n "EMAIL ADDRESS: "
        read EMAIL
        echo -n "Press \"y\" to accept EMAIL ADDRESS. [y/n]:"
        read -n 1 INPUT
        echo ""
    done

    # Get User Name
    INPUT=
    while [ "$INPUT" != "y" -a "$INPUT" != "Y" ]; 
    do
        INPUT=
        USER_NAME=
        echo""
        echo -n "USER NAME: "
        read USER_NAME
        echo -n "Press \"y\" to accept USER NAME. [y/n]:"
        read -n 1 INPUT
        echo ""
        echo ""
    done

    # Create /tmp/details file
    echo "EMAIL=\"$EMAIL\"" > /tmp/details
    echo "CUSTOMER=\"$USER_NAME\"" >> /tmp/details
}

#-------------------
# Start from here
#-------------------

# Import functions
source /opt/userful/bin/userful-bash-lib.sh

#
# Check if user has root access..
IsRoot

[[ -z $1 ]] && usage

case "$1" in
	-h|-help)
		usage
		;;

	-submit)
        createDetails
		exec /usr/share/umx-utils/submit-debug-info.sh
		;;

	*)
		echo -e "\nError: Invalid option - $1"
		usage
		;;
esac

