#!/bin/bash
#
# Copyright (c) 2005-2006 by Userful Corporation
#
# Name: unplug-inputdev.sh
# Author: Jason Kim
# Description:
#    This script is called from "remove" section of input.agent. It starts GUI for
#	kbd-assignment if a keyboard device has been removed. 
#
# $1: Phys path
##################################################################################

logfile="/var/log/userful-start.log"
usbinput_logfile="/var/log/usbinput.log"
ProgramName=`basename $0`
LOCK_FILE="/tmp/usbinput.lock"

MATCHED_DEVNUM=
UNPLUG_DEVICE=
PROTOCOL=

TRUE=1
FALSE=0
SCREENNUM=
PHYS=

# start GUI for kbd-assignment. unconfigure devices that have same screenNum.
function unplug_kbd()
{
	##
	## /etc/usbinput should be accessed exclusively.
	while ! (set -C; : > $LOCK_FILE) 2> /dev/null; do
		sleep 0.2
	done

	rm -f /tmp/unplug.tmp.$SCREENNUM

	while read USBINPUT; do
		# find usbinput entries having same screen number
    	if echo "$USBINPUT" | grep "Srn#=$SCREENNUM" > /dev/null; then
			if [ ${USBINPUT:1:1} -eq 1 ]; then  # If the current device is configured
	    		USBINPUT=${USBINPUT/1/0}   # replace 1 to 0  (first match)
			fi
    	fi
    	echo "$USBINPUT" >> /tmp/unplug.tmp.$SCREENNUM
	done < /etc/usbinput
	cp -f /tmp/unplug.tmp.$SCREENNUM /etc/usbinput

	# update configstat
	/opt/userful/bin/make-config-file -u

    # Check Mandatory device
    if [ -f /opt/userful/bin/umx-mandatory-dev-refresh.sh ]; then
        /opt/userful/bin/umx-mandatory-dev-refresh.sh
    fi

	## delete lock file
	rm -f $LOCK_FILE

	# find current display manager
	if [ -f /etc/userful-currentdm ]; then
    	source /etc/userful-currentdm
	else
		CURRENTDM=gdm
	fi
	#echo "unplug-inputdev.sh  current dm: $CURRENTDM" >> $logfile

	# check if GUI for kbd-assignment exists on the $SCREENNUM display
	if [ ! -e /var/run/pid.kbdlink$((10#$SCREENNUM)) -o \
		 ! -d /proc/`cat /var/run/pid.kbdlink$((10#$SCREENNUM))` ]; then

		if [ "$CURRENTDM" == "kdm" -o "$CURRENTDM" == "xdm" ]; then
			/opt/userful/bin/checkGrabKeyboard -display :$((10#$SCREENNUM))
			RET=$?

			if [ $RET -eq $TRUE ]; then
				#echo "unplug-inputdev.sh  kill login-server" >> $logfile
				kill `cat /var/run/pid.login-server$((10#$SCREENNUM))`
			else
				#echo "unplug-inputdev.sh  start GUI" >> $logfile
				/opt/userful/bin/userful-usbinput-config -display :$((10#$SCREENNUM)) -r &
			fi
		else
			#echo "unplug-inputdev.sh  start GUI" >> $logfile
			/opt/userful/bin/userful-usbinput-config -display :$((10#$SCREENNUM)) -r &
		fi
		sleep 0.5
	else
		#echo "unplug-inputdev.sh  GUI is exist already.." >> $logfile
		:
	fi
}

usage()
{
    echo
    echo "Usage: $0 <phys>"
    echo
    exit 1
}

#
# start here...
#
# $1: Phys path

# Exit if normal X is running
if [ -f /etc/sysconfig/xtype ]; then
	source /etc/sysconfig/xtype

	if [ "$XTYPE" = SINGLE -o "$XTYPE" = single ]; then
		exit 1
	fi
fi

# receive only one argument(phys).
if [ $# -ne 1 ]; then
    usage
fi

# remove " from the $1
PHYS=`echo $1 | tr -d "\""`

# check device type.
# hotplug(unplugging) only works for USB devices
devtype=`echo "$PHYS" | head -c 3`
#echo "unplug-inputdev.sh  devtype: $devtype" >> $logfile
if [ "$PHYS" == "" -o "$devtype" == "isa" ]; then
	exit 1
fi

echo "`date +"%b %d %T"` $ProgramName:  $PHYS removed." >> $usbinput_logfile
echo "`date +"%b %d %T"` $ProgramName:  $PHYS removed." >> $logfile

# Check the device config type.  If it is static, then exit program.
if [[ -f /etc/userful/umx.conf ]]; then
    sed -e "s/^\[/#\[/g" /etc/userful/umx.conf > /tmp/umx.conf.tmp
    source /tmp/umx.conf.tmp
fi
if [ "$DEVCONF" == "static" ]; then
    echo "`date +"%b %d %T"` $ProgramName: Current device config type is static. Do nothing." >> $logfile
    exit 0
fi

MATCHED_DEVNUM=`grep "$PHYS" /etc/usbinput | wc -l`
if [ $MATCHED_DEVNUM -eq 0 ]; then
	# No matched device
	echo "No matched device" >> $logfile
	exit 1
elif [ $MATCHED_DEVNUM -gt 1 ]; then
	# There are more than one device that has same PHYS
	# MiTouch has "/input0" value for PHYS in the kernel 1833

	/opt/userful/bin/make-config-file -u

    # Check Mandatory device
    if [ -f /opt/userful/bin/umx-mandatory-dev-refresh.sh ]; then
        /opt/userful/bin/umx-mandatory-dev-refresh.sh
    fi
	/opt/userful/bin/send_signal
	pkill -USR2 kbd-daemon
	pkill -USR2 mse-daemon
	exit 1
fi

UNPLUG_DEVICE=`grep "$PHYS" /etc/usbinput`
SCREENNUM=${UNPLUG_DEVICE:32:2}
PROTOCOL=${UNPLUG_DEVICE:40:2}

case "$PROTOCOL" in
	"01" ) # keyboard
		unplug_kbd
		;;
	"02"|"03"|"04" ) # Mouse, Card reader and Magnetic swipe
		/opt/userful/bin/make-config-file -u
		;;
	"05" ) # Touch Screen
		/opt/userful/bin/make-config-file -u
		/opt/userful/bin/send_signal
		pkill -USR2 kbd-daemon
		pkill -USR2 mse-daemon
		;;
esac
